# generated by datamodel-codegen:
#   filename:  openapi_new.json
#   timestamp: 2025-07-17T03:14:16+00:00

from __future__ import annotations

from typing import Annotated, Any, Dict, List, Optional, Union

from pydantic import BaseModel, Field


class ValidationErrorJudgmentType(BaseModel):
    loc: Annotated[List[Union[str, int]], Field(title="Location")]
    msg: Annotated[str, Field(title="Message")]
    type: Annotated[str, Field(title="Error Type")]


class ScorerDataJudgmentType(BaseModel):
    name: Annotated[str, Field(title="Name")]
    threshold: Annotated[float, Field(title="Threshold")]
    success: Annotated[bool, Field(title="Success")]
    score: Annotated[Optional[float], Field(title="Score")] = None
    reason: Annotated[Optional[str], Field(title="Reason")] = None
    strict_mode: Annotated[Optional[bool], Field(title="Strict Mode")] = None
    evaluation_model: Annotated[
        Optional[Union[List[str], str]], Field(title="Evaluation Model")
    ] = None
    error: Annotated[Optional[str], Field(title="Error")] = None
    additional_metadata: Annotated[
        Optional[Dict[str, Any]], Field(title="Additional Metadata")
    ] = None


class ScorerConfigJudgmentType(BaseModel):
    score_type: Annotated[str, Field(title="Score Type")]
    name: Annotated[Optional[str], Field(title="Name")] = None
    threshold: Annotated[Optional[float], Field(title="Threshold")] = 0.5
    strict_mode: Annotated[Optional[bool], Field(title="Strict Mode")] = False
    required_params: Annotated[Optional[List[str]], Field(title="Required Params")] = (
        Field(default_factory=list)
    )
    kwargs: Annotated[Optional[Dict[str, Any]], Field(title="Kwargs")] = None


class TraceUsageJudgmentType(BaseModel):
    prompt_tokens: Annotated[Optional[int], Field(title="Prompt Tokens")] = None
    completion_tokens: Annotated[Optional[int], Field(title="Completion Tokens")] = None
    cache_creation_input_tokens: Annotated[
        Optional[int], Field(title="Cache Creation Input Tokens")
    ] = None
    cache_read_input_tokens: Annotated[
        Optional[int], Field(title="Cache Read Input Tokens")
    ] = None
    total_tokens: Annotated[Optional[int], Field(title="Total Tokens")] = None
    prompt_tokens_cost_usd: Annotated[
        Optional[float], Field(title="Prompt Tokens Cost Usd")
    ] = None
    completion_tokens_cost_usd: Annotated[
        Optional[float], Field(title="Completion Tokens Cost Usd")
    ] = None
    total_cost_usd: Annotated[Optional[float], Field(title="Total Cost Usd")] = None
    model_name: Annotated[Optional[str], Field(title="Model Name")] = None


class ToolJudgmentType(BaseModel):
    tool_name: Annotated[str, Field(title="Tool Name")]
    parameters: Annotated[Optional[Dict[str, Any]], Field(title="Parameters")] = None
    agent_name: Annotated[Optional[str], Field(title="Agent Name")] = None
    result_dependencies: Annotated[
        Optional[List[Dict[str, Any]]], Field(title="Result Dependencies")
    ] = None
    action_dependencies: Annotated[
        Optional[List[Dict[str, Any]]], Field(title="Action Dependencies")
    ] = None
    require_all: Annotated[Optional[bool], Field(title="Require All")] = None


class HTTPValidationErrorJudgmentType(BaseModel):
    detail: Annotated[
        Optional[List[ValidationErrorJudgmentType]], Field(title="Detail")
    ] = None


class TraceSpanJudgmentType(BaseModel):
    span_id: Annotated[str, Field(title="Span Id")]
    trace_id: Annotated[str, Field(title="Trace Id")]
    function: Annotated[str, Field(title="Function")]
    depth: Annotated[int, Field(title="Depth")]
    created_at: Annotated[Any, Field(title="Created At")] = None
    parent_span_id: Annotated[Optional[str], Field(title="Parent Span Id")] = None
    span_type: Annotated[Optional[str], Field(title="Span Type")] = "span"
    inputs: Annotated[Optional[Dict[str, Any]], Field(title="Inputs")] = None
    error: Annotated[Optional[Dict[str, Any]], Field(title="Error")] = None
    output: Annotated[Any, Field(title="Output")] = None
    usage: Optional[TraceUsageJudgmentType] = None
    duration: Annotated[Optional[float], Field(title="Duration")] = None
    expected_tools: Annotated[
        Optional[List[ToolJudgmentType]], Field(title="Expected Tools")
    ] = None
    additional_metadata: Annotated[
        Optional[Dict[str, Any]], Field(title="Additional Metadata")
    ] = None
    has_evaluation: Annotated[Optional[bool], Field(title="Has Evaluation")] = False
    agent_name: Annotated[Optional[str], Field(title="Agent Name")] = None
    state_before: Annotated[Optional[Dict[str, Any]], Field(title="State Before")] = (
        None
    )
    state_after: Annotated[Optional[Dict[str, Any]], Field(title="State After")] = None
    update_id: Annotated[Optional[int], Field(title="Update Id")] = 1


class ExampleJudgmentType(BaseModel):
    input: Annotated[Optional[Union[str, Dict[str, Any]]], Field(title="Input")] = None
    actual_output: Annotated[
        Optional[Union[str, List[str]]], Field(title="Actual Output")
    ] = None
    expected_output: Annotated[
        Optional[Union[str, List[str]]], Field(title="Expected Output")
    ] = None
    context: Annotated[Optional[List[str]], Field(title="Context")] = None
    retrieval_context: Annotated[
        Optional[List[str]], Field(title="Retrieval Context")
    ] = None
    additional_metadata: Annotated[
        Optional[Dict[str, Any]], Field(title="Additional Metadata")
    ] = None
    tools_called: Annotated[Optional[List[str]], Field(title="Tools Called")] = Field(
        default_factory=list
    )
    expected_tools: Annotated[
        Optional[List[ToolJudgmentType]], Field(title="Expected Tools")
    ] = Field(default_factory=list)
    name: Annotated[Optional[str], Field(title="Name")] = None
    example_id: Annotated[str, Field(title="Example Id")]
    example_index: Annotated[Optional[int], Field(title="Example Index")] = None
    created_at: Annotated[Optional[str], Field(title="Created At")] = None
    trace_id: Annotated[Optional[str], Field(title="Trace Id")] = None
    trace_span_id: Annotated[Optional[str], Field(title="Trace Span Id")] = None
    dataset_id: Annotated[Optional[str], Field(title="Dataset Id")] = None


class TraceJudgmentType(BaseModel):
    trace_id: Annotated[str, Field(title="Trace Id")]
    name: Annotated[str, Field(title="Name")]
    created_at: Annotated[str, Field(title="Created At")]
    duration: Annotated[float, Field(title="Duration")]
    trace_spans: Annotated[List[TraceSpanJudgmentType], Field(title="Trace Spans")]
    overwrite: Annotated[Optional[bool], Field(title="Overwrite")] = False
    offline_mode: Annotated[Optional[bool], Field(title="Offline Mode")] = False
    rules: Annotated[Optional[Dict[str, Any]], Field(title="Rules")] = Field(
        default_factory=dict
    )
    has_notification: Annotated[Optional[bool], Field(title="Has Notification")] = False
    customer_id: Annotated[Optional[str], Field(title="Customer Id")] = None
    tags: Annotated[Optional[List[str]], Field(title="Tags")] = Field(
        default_factory=list
    )
    metadata: Annotated[Optional[Dict[str, Any]], Field(title="Metadata")] = Field(
        default_factory=dict
    )
    update_id: Annotated[Optional[int], Field(title="Update Id")] = 1


class ScoringResultJudgmentType(BaseModel):
    success: Annotated[bool, Field(title="Success")]
    scorers_data: Annotated[
        Optional[List[ScorerDataJudgmentType]], Field(title="Scorers Data")
    ]
    name: Annotated[Optional[str], Field(title="Name")] = None
    data_object: Annotated[
        Optional[Union[TraceSpanJudgmentType, ExampleJudgmentType]],
        Field(title="Data Object"),
    ] = None
    trace_id: Annotated[Optional[str], Field(title="Trace Id")] = None
    run_duration: Annotated[Optional[float], Field(title="Run Duration")] = None
    evaluation_cost: Annotated[Optional[float], Field(title="Evaluation Cost")] = None


class TraceRunJudgmentType(BaseModel):
    project_name: Annotated[Optional[str], Field(title="Project Name")] = None
    eval_name: Annotated[Optional[str], Field(title="Eval Name")] = None
    traces: Annotated[List[TraceJudgmentType], Field(title="Traces")]
    scorers: Annotated[List[ScorerConfigJudgmentType], Field(title="Scorers")]
    model: Annotated[str, Field(title="Model")]
    append: Annotated[Optional[bool], Field(title="Append")] = False
    override: Annotated[Optional[bool], Field(title="Override")] = False
    trace_span_id: Annotated[Optional[str], Field(title="Trace Span Id")] = None
    tools: Annotated[Optional[List[Dict[str, Any]]], Field(title="Tools")] = None


class JudgmentEvalJudgmentType(BaseModel):
    project_name: Annotated[Optional[str], Field(title="Project Name")] = None
    eval_name: Annotated[Optional[str], Field(title="Eval Name")] = None
    examples: Annotated[List[ExampleJudgmentType], Field(title="Examples")]
    scorers: Annotated[List[ScorerConfigJudgmentType], Field(title="Scorers")]
    model: Annotated[str, Field(title="Model")]
    append: Annotated[Optional[bool], Field(title="Append")] = False
    override: Annotated[Optional[bool], Field(title="Override")] = False
    trace_span_id: Annotated[Optional[str], Field(title="Trace Span Id")] = None


class EvalResultsJudgmentType(BaseModel):
    results: Annotated[List[ScoringResultJudgmentType], Field(title="Results")]
    run: Annotated[
        Union[TraceRunJudgmentType, JudgmentEvalJudgmentType], Field(title="Run")
    ]
