"""Sample Tap for CSV files."""

from __future__ import annotations

import singer_sdk.typing as th
from singer_sdk.contrib.filesystem import FolderTap
from tap_csv.client import CSVStream


class TapCSV(FolderTap):
    """Sample Tap for CSV files."""

    name = "tap-csv"
    valid_extensions: tuple[str, ...] = (".csv",)
    default_stream_class = CSVStream

    config_jsonschema = th.PropertiesList(
        th.Property(
            "delimiter",
            th.StringType,
            default=",",
            title="Delimiter",
            description="Field delimiter character.",
        ),
        th.Property(
            "quotechar",
            th.StringType,
            default='"',
            title="Quote Character",
            description="Quote character.",
        ),
        th.Property(
            "escapechar",
            th.StringType,
            default=None,
            title="Escape Character",
            description="Escape character.",
        ),
        th.Property(
            "doublequote",
            th.BooleanType,
            default=True,
            title="Double Quote",
            description="Whether quotechar inside a field should be doubled.",
        ),
        th.Property(
            "lineterminator",
            th.StringType,
            default="\r\n",
            title="Line Terminator",
            description="Line terminator character.",
        ),
    ).to_dict()
