# Generated by Django 4.2.21 on 2025-05-29 21:29

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import mojo.models.rest
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now_add=True)),
                ('last_activity', models.DateTimeField(db_index=True, default=None, null=True)),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('username', models.TextField(unique=True)),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('phone_number', models.CharField(blank=True, default=None, max_length=32, null=True)),
                ('display_name', models.CharField(blank=True, default=None, max_length=80, null=True)),
                ('auth_key', models.TextField(default=None, null=True)),
                ('onetime_code', models.TextField(default=None, null=True)),
                ('permissions', models.JSONField(blank=True, default=dict)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('first_name', models.CharField(default='', max_length=80)),
                ('last_name', models.CharField(default='', max_length=80)),
                ('is_active', models.BooleanField(default=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('is_superuser', models.BooleanField(default=False)),
                ('date_joined', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('name', models.CharField(max_length=200)),
                ('uuid', models.CharField(db_index=True, default=None, max_length=200, null=True)),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('kind', models.CharField(db_index=True, default='group', max_length=80)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('parent', models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='groups', to='account.group')),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
        migrations.CreateModel(
            name='GroupMember',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True, db_index=True)),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('permissions', models.JSONField(blank=True, default=dict)),
                ('metadata', models.JSONField(blank=True, default=dict)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to='account.group')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='members', to=settings.AUTH_USER_MODEL)),
            ],
            bases=(models.Model, mojo.models.rest.MojoModel),
        ),
    ]
