# Generated by Django 3.2.9 on 2022-02-18 13:25

import dirtyfields.dirtyfields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import easy_thumbnails.fields
import simo.core.storage
import simo.core.utils.mixins
import simo.core.utils.validators
import taggit.managers


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('taggit', '0003_taggeditem_add_unique_index'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40, verbose_name='name')),
                ('header_image', easy_thumbnails.fields.ThumbnailerImageField(blank=True, help_text='Will be cropped down to: 830x430', null=True, upload_to='categories')),
                ('header_image_last_change', models.DateTimeField(auto_now_add=True)),
                ('all', models.BooleanField(default=False, help_text='All components automatically belongs to this category')),
                ('order', models.PositiveIntegerField(db_index=True, default=0)),
            ],
            options={
                'verbose_name': 'category',
                'verbose_name_plural': 'categories',
                'ordering': ('order', 'id'),
            },
            bases=(dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model, simo.core.utils.mixins.SimoAdminMixin),
        ),
        migrations.CreateModel(
            name='Component',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=100, verbose_name='name')),
                ('base_type', models.CharField(db_index=True, max_length=200, verbose_name='base type')),
                ('controller_uid', models.CharField(choices=[], db_index=True, max_length=200, verbose_name='type')),
                ('config', models.JSONField(blank=True, default=dict, editable=False, verbose_name='component config')),
                ('value', models.JSONField(blank=True, null=True)),
                ('value_previous', models.JSONField(blank=True, editable=False, null=True)),
                ('value_units', models.CharField(blank=True, max_length=100, null=True)),
                ('change_init_date', models.DateTimeField(editable=False, null=True)),
                ('last_update', models.DateTimeField(auto_now=True)),
                ('alive', models.BooleanField(default=True)),
                ('battery_level', models.PositiveIntegerField(editable=False, null=True)),
                ('show_in_app', models.BooleanField(db_index=True, default=True)),
                ('instance_methods', models.TextField(blank=True, default="\n\ndef is_in_alarm(self):\n    return bool(self.value)\n\ndef translate_before_send(self, value):\n    '''Perform value translation just before sending it to device.'''\n    return value\n\ndef translate_before_set(self, value):\n    '''Perform value translation just before value is set to component.\n    Must return a valid value for this component type.'''\n    return value\n\n", help_text='Add your own component methods or override existing ones')),
                ('alarm_category', models.CharField(blank=True, choices=[('security', 'Security'), ('fire', 'Fire'), ('flood', 'Flood'), ('other', 'Other')], db_index=True, help_text='Enable alarm properties by choosing one of alarm categories.', max_length=50, null=True)),
                ('arm_status', models.CharField(choices=[('disarmed', 'Disarmed'), ('pending-arm', 'Pending Arm'), ('armed', 'Armed'), ('breached', 'Breached')], db_index=True, default='disarmed', max_length=20)),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='components', to='core.category')),
                ('change_init_by', models.ForeignKey(editable=False, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Component',
                'verbose_name_plural': 'Components',
                'ordering': ('zone', 'name'),
            },
            bases=(dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model, simo.core.utils.mixins.SimoAdminMixin),
        ),
        migrations.CreateModel(
            name='Gateway',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[], db_index=True, max_length=200, unique=True)),
                ('config', models.JSONField(blank=True, default=dict, verbose_name='gateway config')),
                ('status', models.CharField(blank=True, choices=[('running', 'Running'), ('stopped', 'Stopped'), ('finished', 'Finished'), ('error', 'Error')], max_length=20, null=True)),
            ],
            bases=(dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model, simo.core.utils.mixins.SimoAdminMixin),
        ),
        migrations.CreateModel(
            name='Icon',
            fields=[
                ('slug', models.SlugField(primary_key=True, serialize=False, unique=True)),
                ('keywords', models.CharField(blank=True, max_length=500, null=True)),
                ('default', models.FileField(help_text='Only .svg file format is allowed.', storage=simo.core.storage.OverwriteStorage(), upload_to='icons', validators=[simo.core.utils.validators.validate_svg], verbose_name='Default (off)')),
                ('active', models.FileField(blank=True, help_text='Only .svg file format is allowed.', null=True, storage=simo.core.storage.OverwriteStorage(), upload_to='icons', validators=[simo.core.utils.validators.validate_svg], verbose_name='Active (on)')),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('copyright', models.CharField(db_index=True, help_text='You are only allowed to use this icon in SIMO.io project if this field has value.', max_length=200, null=True)),
            ],
            options={
                'ordering': ('-active', 'slug'),
            },
            bases=(dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model, simo.core.utils.mixins.SimoAdminMixin),
        ),
        migrations.CreateModel(
            name='Zone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=40, verbose_name='name')),
                ('order', models.PositiveIntegerField(db_index=True, default=0)),
            ],
            options={
                'verbose_name': 'zone',
                'verbose_name_plural': 'zones',
                'ordering': ('order', 'id'),
            },
            bases=(dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model, simo.core.utils.mixins.SimoAdminMixin),
        ),
        migrations.CreateModel(
            name='ComponentHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('type', models.CharField(choices=[('value', 'Value'), ('security', 'Security')], max_length=50)),
                ('value', models.JSONField(blank=True, null=True)),
                ('component', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='history', to='core.component')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-date',),
            },
        ),
        migrations.AddField(
            model_name='component',
            name='gateway',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='components', to='core.gateway'),
        ),
        migrations.AddField(
            model_name='component',
            name='icon',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.icon'),
        ),
        migrations.AddField(
            model_name='component',
            name='tags',
            field=taggit.managers.TaggableManager(blank=True, help_text='A comma-separated list of tags.', through='taggit.TaggedItem', to='taggit.Tag', verbose_name='Tags'),
        ),
        migrations.AddField(
            model_name='component',
            name='zone',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='components', to='core.zone'),
        ),
        migrations.AddField(
            model_name='category',
            name='icon',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.icon'),
        ),
    ]
