# Generated by Django 2.2.12 on 2021-11-04 14:00
import os
import sys
import json
from django.db import migrations


def create_objects(apps, schema_editor):

    Icon = apps.get_model("core", "Icon")

    core_dir_path = os.path.dirname(os.path.dirname(os.path.realpath(__file__)))

    icons_folder = os.path.join(
        core_dir_path, 'static/third_party/fontawesome-pro'
    )
    off_ons = {}
    on_off_file_path = os.path.join(icons_folder, 'metadata', 'on-off.txt')
    if os.path.exists(on_off_file_path):
        with open(os.path.join(icons_folder, 'metadata', 'on-off.txt')) as f:
            for line in f.readlines():
                on, off = line.split(',')
                on = on.strip()
                off = off.strip()
                off_ons[off] = on

    with open(os.path.join(icons_folder, 'metadata', 'icons.json')) as f:
        icons_json = json.load(f)

    i = 0
    for slug, data in icons_json.items():
        if 'regular' not in data['styles']:
            continue

        # load only a few icons for testing
        if 'test' in sys.argv and slug not in (
            'star', 'temperature-half', 'lightbulb', 'eye', 'faucet',
            'flag-pennant', 'cloud-bolt-sun'
        ):
            continue

        i += 1
        icon, new = Icon.objects.get_or_create(slug=slug)

        icon.copyright = 'Font Awesome Pro'
        icon.keywords = ', '.join([str(t) for t in data['search']['terms']])
        aliases = ', '.join(
            [str(t) for t in data.get('aliases', {}).get('names', [])]
        )
        if aliases:
            icon.keywords += ', %s' % aliases
        filename = slug + '.svg'
        icon.default.save(
            filename,
            open(os.path.join(icons_folder, 'svgs', 'regular', filename))
        )
        icon.save()


def delete_objects(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_objects, delete_objects),
    ]
