# Generated by Django 4.2.10 on 2024-03-06 08:00

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('fleet', '0025_auto_20240130_1334'),
    ]

    operations = [
        migrations.RenameField(
            model_name='i2cinterface',
            old_name='scl_pin',
            new_name='scl_pin_no',
        ),
        migrations.RenameField(
            model_name='i2cinterface',
            old_name='sda_pin',
            new_name='sda_pin_no',
        ),
        migrations.CreateModel(
            name='ColonelPin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('no', models.PositiveIntegerField()),
                ('input', models.BooleanField(db_index=True, default=False)),
                ('output', models.BooleanField(db_index=True, default=False)),
                ('capacitive', models.BooleanField(db_index=True, default=False)),
                ('adc', models.BooleanField(default=False)),
                ('native', models.BooleanField(db_index=True, default=True)),
                ('default_pull', models.CharField(blank=True, choices=[('LOW', 'LOW'), ('HIGH', 'HIGH')], db_index=True, max_length=50, null=True)),
                ('note', models.CharField(max_length=100)),
                ('occupied_by_id', models.PositiveIntegerField(null=True)),
                ('colonel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pins', to='fleet.colonel')),
                ('occupied_by_content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, null=True, to='contenttypes.contenttype')),
            ],
            options={
                'indexes': [models.Index(fields=['occupied_by_content_type', 'occupied_by_id'], name='fleet_colon_occupie_f2bfd0_idx')],
                'unique_together': {('colonel', 'no')},
            },
        ),
        migrations.AddField(
            model_name='i2cinterface',
            name='scl_pin',
            field=models.ForeignKey(
                to='fleet.ColonelPin', on_delete=django.db.models.CASCADE,
                limit_choices_to={'native': True},
                null=True, related_name='i2c_scl'
            ),
        ),
        migrations.AddField(
            model_name='i2cinterface',
            name='sda_pin',
            field=models.ForeignKey(
                to='fleet.ColonelPin', on_delete=django.db.models.CASCADE,
                limit_choices_to={'native': True},
                null=True, related_name='i2c_sda'
            ),
        ),
    ]
