# Generated by Django 4.2.10 on 2024-03-06 08:02
import traceback
import json
import sys
from django.db import migrations


def forwards_func(apps, schema_editor):
    from simo.fleet.utils import GPIO_PINS
    #from django.contrib.contenttypes.models import ContentType

    Colonel = apps.get_model('fleet', "Colonel")
    ColonelPin = apps.get_model("fleet", "ColonelPin")
    Component = apps.get_model('core', "Component")

    new_pins = {}

    for colonel in Colonel.objects.all():
        new_pins[colonel.id] = {}
        for no, data in GPIO_PINS.get(colonel.type).items():
            new_pins[colonel.id][no] = ColonelPin.objects.create(
                colonel=colonel, no=no,
                input=data.get('input'), output=data.get('output'),
                capacitive=data.get('capacitive'), adc=data.get('adc'),
                native=data.get('native'), note=data.get('note')
            )

        for i2c in colonel.i2c_interfaces.all():
            #ct = ContentType.objects.get_for_model(i2c)

            scl_pin = new_pins[colonel.id][i2c.scl_pin_no]
            #scl_pin.occupied_by_content_type = ct
            #scl_pin.occupied_by_id = i2c.id
            scl_pin.save()
            i2c.scl_pin = scl_pin
            i2c.scl_pin.save()

            sda_pin = new_pins[colonel.id][i2c.sda_pin_no]
            #sda_pin.occupied_by_content_type = ct
            #sda_pin.occupied_by_id = i2c.id
            sda_pin.save()

            i2c.sda_pin = sda_pin
            i2c.sda_pin.save()

    print("NEW pins: ", new_pins)

    for comp in Component.objects.filter(
        controller_uid__startswith='simo.fleet.'
    ):
        #ct = ContentType.objects.get_for_model(comp)
        try:
            colonel = Colonel.objects.get(id=comp.config['colonel'])
        except Exception as e:
            print(traceback.format_exc(), file=sys.stderr)
            continue
        if 'pin' in comp.config:
            comp.config['pin_no'] = comp.config.pop('pin')

            if comp.config['pin_no'] not in new_pins[colonel.id]:
                print("BAD COMPONENT CONFIG!")
                comp.delete()
                continue

            pin = new_pins[colonel.id][comp.config['pin_no']]
            comp.config['pin'] = pin.pk
            #pin.occupied_by_content_type = ct
            #pin.occupied_by_id = comp.id
            pin.save()
        if 'power_pin' in comp.config:
            comp.config['power_pin_no'] = comp.config.pop('power_pin')

            if comp.config['power_pin_no'] not in new_pins[colonel.id]:
                print("BAD COMPONENT CONFIG!")
                comp.delete()
                continue

            pin = new_pins[colonel.id][comp.config['power_pin_no']]
            comp.config['power_pin'] = pin.pk
            #pin.occupied_by_content_type = ct
            #pin.occupied_by_id = comp.id
            pin.save()
        if 'sensor_pin' in comp.config:
            comp.config['sensor_pin_no'] = comp.config.pop('sensor_pin')

            if comp.config['sensor_pin_no'] not in new_pins[colonel.id]:
                print("BAD COMPONENT CONFIG!")
                comp.delete()
                continue

            pin = new_pins[colonel.id][comp.config['sensor_pin_no']]
            comp.config['sensor_pin'] = pin.pk
            #pin.occupied_by_content_type = ct
            #pin.occupied_by_id = comp.id
            pin.save()
        if 'output_pin' in comp.config:
            comp.config['output_pin_no'] = comp.config.pop('output_pin')

            if comp.config['output_pin_no'] not in new_pins[colonel.id]:
                print("BAD COMPONENT CONFIG!")
                comp.delete()
                continue

            pin = new_pins[colonel.id][comp.config['output_pin_no']]
            comp.config['output_pin'] = pin.pk
            #pin.occupied_by_content_type = ct
            #pin.occupied_by_id = comp.id
            pin.save()
        if 'open_pin' in comp.config:
            comp.config['open_pin_no'] = comp.config.pop('open_pin')

            if comp.config['open_pin_no'] not in new_pins[colonel.id]:
                print("BAD COMPONENT CONFIG!")
                comp.delete()
                continue

            pin = new_pins[colonel.id][comp.config['open_pin_no']]
            comp.config['open_pin'] = pin.pk
            #pin.occupied_by_content_type = ct
            #pin.occupied_by_id = comp.id
            pin.save()
        if 'close_pin' in comp.config:
            comp.config['close_pin_no'] = comp.config.pop('close_pin')

            if comp.config['close_pin_no'] not in new_pins[colonel.id]:
                print("BAD COMPONENT CONFIG!")
                comp.delete()
                continue

            pin = new_pins[colonel.id][comp.config['close_pin_no']]
            comp.config['close_pin'] = pin.pk
            #pin.occupied_by_content_type = ct
            #pin.occupied_by_id = comp.id
            pin.save()

        if 'controls' in comp.config:
            for i, control in enumerate(comp.config['controls']):
                updated_controls = json.loads(json.dumps(control))
                updated_controls['pin_no'] = control['pin']

                if updated_controls['pin_no'] not in new_pins[colonel.id]:
                    print("BAD COMPONENT CONFIG!")
                    comp.delete()
                    continue

                pin = new_pins[colonel.id][updated_controls['pin_no']]
                updated_controls['pin'] = pin.pk

                #pin.occupied_by_content_type = ct
                #pin.occupied_by_id = comp.id
                pin.save()

                comp.config['controls'][i] = updated_controls

        comp.save()


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('fleet', '0026_rename_i2cinterface_scl_pin_and_more'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func, elidable=True),
    ]
