# Generated by Django 3.2.9 on 2024-06-05 07:02

from django.db import migrations


def forwards_func(apps, schema_editor):
    from simo.fleet.utils import GPIO_PINS
    Component = apps.get_model("core", "Component")
    Colonel = apps.get_model('fleet', "Colonel")
    ColonelPin = apps.get_model('fleet', "ColonelPin")
    for comp in Component.objects.filter(config__has_key='controls'):
        if not isinstance(comp.config['controls'], list):
            continue
        for ctrl in comp.config['controls']:
            if 'pin_no' in ctrl and 'pin' in ctrl:
                ctrl['input'] = f"pin-{ctrl['pin']}"
                del ctrl['pin']
            if 'pin' in ctrl and 'pin_no' not in ctrl:
                # time to fix legacy remainings..
                colonel = Colonel.objects.filter(
                    id=comp.config.get('colonel', 0)
                ).first()
                if not colonel:
                    # Colonel no longer exists, there is no point in
                    # continuing with this
                    comp.config['controls'] = []
                    continue
                try:
                    pin_no = ctrl['pin']
                except:
                    continue

                pin_data = {}
                for no, pin_data in GPIO_PINS.get(colonel.type).items():
                    if no == pin_no:
                        break
                pin, new = ColonelPin.objects.get_or_create(
                    colonel=colonel, no=pin_no,
                    defaults={
                        'input': pin_data.get('input'),
                        'output': pin_data.get('output'),
                        'capacitive': pin_data.get('capacitive'),
                        'adc': pin_data.get('adc'),
                        'native': pin_data.get('native'),
                        'note': pin_data.get('note')
                    }
                )

                ctrl['pin_no'] = pin.no
                ctrl['input'] = f'pin-{pin.id}'
                del ctrl['pin']

        comp.save()


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('fleet', '0035_auto_20240514_0855'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func, elidable=True),
    ]
