# Generated by Django 4.2.10 on 2024-10-16 10:47
from django.db import migrations


def forwards_func(apps, schema_editor):
    Component = apps.get_model("core", "Component")

    for comp in Component.objects.filter(controller_uid='simo.fleet.controllers.PWMOutput'):
        duty_min = comp.config.get('duty_min', 0)
        duty_max = comp.config.get('duty_max', 1023)
        comp.config['device_min'] = int((1023 - duty_max) / 1023 * 100)
        comp.config['device_max'] = int(100 - (duty_min / 1023 * 100))
        comp.save()


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('fleet', '0038_alter_colonel_type'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func, elidable=True),
    ]
