# Generated by Django 4.2.10 on 2025-05-07 12:56

from django.db import migrations

def forwards_func(apps, schema_editor):
    Component = apps.get_model("core", "Component")
    ColonelPin = apps.get_model('fleet', "ColonelPin")

    for comp in Component.objects.filter(controller_uid__in=(
        'simo.fleet.controllers.BME680Sensor',
        'simo.fleet.controllers.MCP9808TempSensor',
        'simo.fleet.controllers.ENS160AirQualitySensor'
    )):
        cp = ColonelPin.objects.filter(
            colonel__id=comp.config['colonel'],
            interface=comp.config['i2c_interface']
        ).first()
        if cp:
            comp.config['interface_port'] = cp.id
            comp.save()



def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('fleet', '0053_auto_20250507_0713'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func, elidable=True),
    ]
