# Generated by Django 4.2.10 on 2025-05-09 00:00

from django.db import migrations


I2C_CONTROLLERS = (
    'simo.fleet.controllers.BME680Sensor',
    'simo.fleet.controllers.MCP9808TempSensor',
    'simo.fleet.controllers.ENS160AirQualitySensor',
)


def forwards_func(apps, schema_editor):
    Component = apps.get_model('core', 'Component')
    Interface = apps.get_model('fleet', 'Interface')

    interface_ids = set()
    pending = []
    for comp in Component.objects.filter(controller_uid__in=I2C_CONTROLLERS):
        config = comp.config or {}
        if config.get('interface_no') is not None:
            continue
        interface_id = config.get('i2c_interface')
        if not interface_id:
            continue
        try:
            interface_id = int(interface_id)
        except (TypeError, ValueError):
            continue
        pending.append((comp, interface_id))
        interface_ids.add(interface_id)

    if not pending:
        return

    interfaces = {
        iface.id: iface.no
        for iface in Interface.objects.filter(id__in=interface_ids)
    }

    for comp, interface_id in pending:
        interface_no = interfaces.get(interface_id)
        if interface_no is None:
            continue
        comp.config['interface_no'] = interface_no
        comp.save(update_fields=['config'])


class Migration(migrations.Migration):

    dependencies = [
        ('fleet', '0057_remove_colonel_pwm_frequency_alter_colonel_type'),
    ]

    operations = [
        migrations.RunPython(forwards_func, migrations.RunPython.noop, elidable=True),
    ]
