# Generated by Django 4.2.10 on 2024-11-26 07:26
from django.db import migrations


def forwards_func(apps, schema_editor):
    Component = apps.get_model("core", "Component")

    for script in Component.objects.filter(
        controller_uid='simo.generic.controllers.PresenceLighting'
    ):
        lights = []
        on_value = script.config.pop('on_value', 100)
        off_value = script.config.get('off_value', 0)
        for light_id in script.config.get('lights', []):
            lights.append({
                'light': light_id, 'on_value': on_value, 'off_value': off_value
            })
        script.config['lights'] = lights
        script.save()


def reverse_func(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('generic', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func, elidable=True),
    ]
