# Generated by Django 3.2.9 on 2022-02-18 13:25

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import easy_thumbnails.fields
import location_field.models.plain
import simo.core.utils.helpers
import simo.core.utils.mixins
import simo.users.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('name', models.CharField(max_length=150, verbose_name='name')),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='email address')),
                ('avatar', easy_thumbnails.fields.ThumbnailerImageField(blank=True, help_text='Comes from SIMO.io', null=True, upload_to='avatars')),
                ('avatar_url', models.URLField(blank=True, null=True)),
                ('avatar_last_change', models.DateTimeField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(auto_now_add=True)),
                ('last_action', models.DateTimeField(auto_now_add=True, db_index=True, help_text='Last came home event or any interaction with any component.')),
                ('at_home', models.BooleanField(db_index=True, default=True)),
                ('ssh_key', models.TextField(blank=True, help_text='DO NOT EDIT IT MANUALLY! Comes from SIMO.io. <br>Will be placed in /root/.ssh/authorized_keys if user is active and has superuser rights.', null=True)),
                ('last_seen_location', location_field.models.plain.PlainLocationField(blank=True, help_text='Sent by user mobile app', max_length=63, null=True)),
                ('last_seen_location_datetime', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            bases=(models.Model, simo.core.utils.mixins.SimoAdminMixin),
            managers=[
                ('objects', simo.users.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='PermissionsRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=100)),
                ('can_manage_users', models.BooleanField(default=False)),
                ('is_superuser', models.BooleanField(default=False, help_text='Can log in to admin interface and has all possible permissions everywhere.')),
                ('is_default', models.BooleanField(default=False, help_text='Default new user role.')),
            ],
            options={
                'verbose_name': 'role',
                'verbose_name_plural': 'roles',
            },
        ),
        migrations.CreateModel(
            name='UserDevice',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('os', models.CharField(db_index=True, max_length=100)),
                ('token', models.CharField(db_index=True, max_length=1000, unique=True)),
                ('is_primary', models.BooleanField(db_index=True, default=True)),
                ('last_seen', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('last_seen_location', location_field.models.plain.PlainLocationField(blank=True, max_length=63, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='devices', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-last_seen',),
            },
            bases=(models.Model, simo.core.utils.mixins.SimoAdminMixin),
        ),
        migrations.CreateModel(
            name='UserDeviceReportLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('datetime', models.DateTimeField(auto_now_add=True)),
                ('app_open', models.BooleanField(default=False, help_text='Sent while using app or by background process.')),
                ('relay', models.CharField(blank=True, help_text="Sent via remote relay if specified, otherwise it's from LAN.", max_length=200, null=True)),
                ('location', location_field.models.plain.PlainLocationField(blank=True, max_length=63, null=True)),
                ('at_home', models.BooleanField(default=False)),
                ('user_device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='report_logs', to='users.userdevice')),
            ],
            options={
                'ordering': ('-datetime',),
            },
        ),
        migrations.CreateModel(
            name='HubInvitation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(db_index=True, default=simo.core.utils.helpers.get_random_string, max_length=50)),
                ('issue_date', models.DateTimeField(auto_now_add=True)),
                ('expire_date', models.DateTimeField(default=simo.users.models.get_default_inviation_expire_date)),
                ('to_email', models.EmailField(blank=True, max_length=254, null=True)),
                ('last_sent', models.DateTimeField(blank=True, null=True)),
                ('taken_date', models.DateTimeField(blank=True, null=True)),
                ('from_user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='issued_hub_invitations', to=settings.AUTH_USER_MODEL)),
                ('role', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.permissionsrole')),
                ('taken_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='accepted_hub_invitations', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'invitation',
                'verbose_name_plural': 'invitations',
            },
        ),
        migrations.AddField(
            model_name='user',
            name='role',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.permissionsrole'),
        ),
    ]
