# qoery
Every number on the internet, queryable. Instant access to millions of trusted
statistics through a single natural language query or API call.

# Installation

### Python SDK

Install from PyPI:

```bash
pip install qoery
```

PyPI: [qoery](https://pypi.org/project/qoery/)

### JavaScript SDK

Install from npm:

```bash
npm install qoery
```

npm: [qoery](https://www.npmjs.com/package/qoery)


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.2.0
- Package version: 0.2.1
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://qoery.com](https://qoery.com)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import qoery
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import qoery
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import qoery
from qoery.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.qoery.com/v0
# See configuration.py for a list of all supported configuration parameters.
configuration = qoery.Configuration(
    host = "https://api.qoery.com/v0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with qoery.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = qoery.QueriesApi(api_client)
    query_nl_post_request = qoery.QueryNlPostRequest() # QueryNlPostRequest | Provide JSON body.

    try:
        # Natural Language Query
        api_response = api_instance.query_nl_post(query_nl_post_request)
        print("The response of QueriesApi->query_nl_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling QueriesApi->query_nl_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.qoery.com/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*QueriesApi* | [**query_nl_post**](docs/QueriesApi.md#query_nl_post) | **POST** /query/nl | Natural Language Query
*QueriesApi* | [**query_sql_post**](docs/QueriesApi.md#query_sql_post) | **POST** /query/sql | SQL Query
*UsageApi* | [**usage_get**](docs/UsageApi.md#usage_get) | **GET** /usage | Get usage statistics
*WebScrapingApi* | [**scrape_post**](docs/WebScrapingApi.md#scrape_post) | **POST** /scrape | Structured Web Scrape


## Documentation For Models

 - [ErrorResponse](docs/ErrorResponse.md)
 - [NLQueryRequest](docs/NLQueryRequest.md)
 - [QueryNlPost200Response](docs/QueryNlPost200Response.md)
 - [QueryNlPost200ResponseMeta](docs/QueryNlPost200ResponseMeta.md)
 - [QueryNlPost200ResponseMetaPage](docs/QueryNlPost200ResponseMetaPage.md)
 - [QueryNlPost200ResponseSeriesInner](docs/QueryNlPost200ResponseSeriesInner.md)
 - [QueryNlPost200ResponseSeriesInnerEntity](docs/QueryNlPost200ResponseSeriesInnerEntity.md)
 - [QueryNlPost200ResponseSeriesInnerMetric](docs/QueryNlPost200ResponseSeriesInnerMetric.md)
 - [QueryNlPost200ResponseSeriesInnerObservationsInner](docs/QueryNlPost200ResponseSeriesInnerObservationsInner.md)
 - [QueryNlPost200ResponseSeriesInnerObservationsInnerValue](docs/QueryNlPost200ResponseSeriesInnerObservationsInnerValue.md)
 - [QueryNlPost200ResponseSeriesInnerSource](docs/QueryNlPost200ResponseSeriesInnerSource.md)
 - [QueryNlPost200ResponseSeriesInnerUnit](docs/QueryNlPost200ResponseSeriesInnerUnit.md)
 - [QueryNlPost400Response](docs/QueryNlPost400Response.md)
 - [QueryNlPostRequest](docs/QueryNlPostRequest.md)
 - [QueryResponse](docs/QueryResponse.md)
 - [QuerySqlPostRequest](docs/QuerySqlPostRequest.md)
 - [SQLQueryRequest](docs/SQLQueryRequest.md)
 - [ScrapePost200Response](docs/ScrapePost200Response.md)
 - [ScrapePost200ResponseArtifacts](docs/ScrapePost200ResponseArtifacts.md)
 - [ScrapePost200ResponseMetadata](docs/ScrapePost200ResponseMetadata.md)
 - [ScrapePostRequest](docs/ScrapePostRequest.md)
 - [ScrapeResponse](docs/ScrapeResponse.md)
 - [URLRequest](docs/URLRequest.md)
 - [UsageGet200Response](docs/UsageGet200Response.md)
 - [UsageGet200ResponseEndpoints](docs/UsageGet200ResponseEndpoints.md)
 - [UsageGet200ResponseEndpointsNl](docs/UsageGet200ResponseEndpointsNl.md)
 - [UsageStats](docs/UsageStats.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="ApiKeyAuth"></a>
### ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-Key
- **Location**: HTTP header


## Author

samuel.tinnerholm@gmail.com


