# coding: utf-8

"""
    qoery's API

    Every number on the internet, queryable. Instant access to millions of trusted statistics through a single natural language query or API call.  # Installation  ### Python SDK  Install from PyPI:  ```bash pip install qoery ```  PyPI: [qoery](https://pypi.org/project/qoery/)  ### JavaScript SDK  Install from npm:  ```bash npm install qoery ```  npm: [qoery](https://www.npmjs.com/package/qoery) 

    The version of the OpenAPI document: 0.2.0
    Contact: samuel.tinnerholm@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool
from typing import Optional
from typing_extensions import Annotated
from qoery.models.scrape_post200_response import ScrapePost200Response
from qoery.models.scrape_post_request import ScrapePostRequest

from qoery.api_client import ApiClient, RequestSerialized
from qoery.api_response import ApiResponse
from qoery.rest import RESTResponseType


class WebScrapingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def scrape_post(
        self,
        html: Annotated[Optional[StrictBool], Field(description="Include page HTML inline in response")] = None,
        markdown: Annotated[Optional[StrictBool], Field(description="Include page markdown inline in response")] = None,
        scrape_post_request: Annotated[Optional[ScrapePostRequest], Field(description="Provide JSON body or use query parameter 'url'. Body takes precedence.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ScrapePost200Response:
        """Structured Web Scrape

        Download a web page, and structured data as time series. Use query params `html=true` and/or `markdown=true` to include raw artifacts inline; otherwise artifact URLs are provided in `artifacts`.

        :param html: Include page HTML inline in response
        :type html: bool
        :param markdown: Include page markdown inline in response
        :type markdown: bool
        :param scrape_post_request: Provide JSON body or use query parameter 'url'. Body takes precedence.
        :type scrape_post_request: ScrapePostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._scrape_post_serialize(
            html=html,
            markdown=markdown,
            scrape_post_request=scrape_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ScrapePost200Response",
            '400': "QueryNlPost400Response",
            '401': "QueryNlPost400Response",
            '429': "QueryNlPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def scrape_post_with_http_info(
        self,
        html: Annotated[Optional[StrictBool], Field(description="Include page HTML inline in response")] = None,
        markdown: Annotated[Optional[StrictBool], Field(description="Include page markdown inline in response")] = None,
        scrape_post_request: Annotated[Optional[ScrapePostRequest], Field(description="Provide JSON body or use query parameter 'url'. Body takes precedence.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ScrapePost200Response]:
        """Structured Web Scrape

        Download a web page, and structured data as time series. Use query params `html=true` and/or `markdown=true` to include raw artifacts inline; otherwise artifact URLs are provided in `artifacts`.

        :param html: Include page HTML inline in response
        :type html: bool
        :param markdown: Include page markdown inline in response
        :type markdown: bool
        :param scrape_post_request: Provide JSON body or use query parameter 'url'. Body takes precedence.
        :type scrape_post_request: ScrapePostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._scrape_post_serialize(
            html=html,
            markdown=markdown,
            scrape_post_request=scrape_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ScrapePost200Response",
            '400': "QueryNlPost400Response",
            '401': "QueryNlPost400Response",
            '429': "QueryNlPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def scrape_post_without_preload_content(
        self,
        html: Annotated[Optional[StrictBool], Field(description="Include page HTML inline in response")] = None,
        markdown: Annotated[Optional[StrictBool], Field(description="Include page markdown inline in response")] = None,
        scrape_post_request: Annotated[Optional[ScrapePostRequest], Field(description="Provide JSON body or use query parameter 'url'. Body takes precedence.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Structured Web Scrape

        Download a web page, and structured data as time series. Use query params `html=true` and/or `markdown=true` to include raw artifacts inline; otherwise artifact URLs are provided in `artifacts`.

        :param html: Include page HTML inline in response
        :type html: bool
        :param markdown: Include page markdown inline in response
        :type markdown: bool
        :param scrape_post_request: Provide JSON body or use query parameter 'url'. Body takes precedence.
        :type scrape_post_request: ScrapePostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._scrape_post_serialize(
            html=html,
            markdown=markdown,
            scrape_post_request=scrape_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ScrapePost200Response",
            '400': "QueryNlPost400Response",
            '401': "QueryNlPost400Response",
            '429': "QueryNlPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _scrape_post_serialize(
        self,
        html,
        markdown,
        scrape_post_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if html is not None:
            
            _query_params.append(('html', html))
            
        if markdown is not None:
            
            _query_params.append(('markdown', markdown))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if scrape_post_request is not None:
            _body_params = scrape_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/scrape',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


