# coding: utf-8

"""
    qoery's API

    Every number on the internet, queryable. Instant access to millions of trusted statistics through a single natural language query or API call.  # Installation  ### Python SDK  Install from PyPI:  ```bash pip install qoery ```  PyPI: [qoery](https://pypi.org/project/qoery/)  ### JavaScript SDK  Install from npm:  ```bash npm install qoery ```  npm: [qoery](https://www.npmjs.com/package/qoery) 

    The version of the OpenAPI document: 0.2.0
    Contact: samuel.tinnerholm@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qoery.models.query_nl_post200_response_series_inner_entity import QueryNlPost200ResponseSeriesInnerEntity
from qoery.models.query_nl_post200_response_series_inner_metric import QueryNlPost200ResponseSeriesInnerMetric
from qoery.models.query_nl_post200_response_series_inner_observations_inner import QueryNlPost200ResponseSeriesInnerObservationsInner
from qoery.models.query_nl_post200_response_series_inner_source import QueryNlPost200ResponseSeriesInnerSource
from qoery.models.query_nl_post200_response_series_inner_unit import QueryNlPost200ResponseSeriesInnerUnit
from typing import Optional, Set
from typing_extensions import Self

class QueryNlPost200ResponseSeriesInner(BaseModel):
    """
    A logical group of observations sharing the same entity/metric/unit
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="ID of the series")
    name: Optional[StrictStr] = Field(default=None, description="Human-readable name of the series")
    entity: QueryNlPost200ResponseSeriesInnerEntity
    metric: QueryNlPost200ResponseSeriesInnerMetric
    unit: Optional[QueryNlPost200ResponseSeriesInnerUnit] = None
    source: QueryNlPost200ResponseSeriesInnerSource
    frequency: Optional[StrictStr] = Field(default=None, description="Frequency of the time series (e.g., monthly, annual)")
    description: Optional[StrictStr] = Field(default=None, description="Description of the series")
    labels: Optional[Dict[str, Any]] = Field(default=None, description="Additional labels and metadata at the series level")
    observations: List[QueryNlPost200ResponseSeriesInnerObservationsInner] = Field(description="The ordered observations for this series")
    __properties: ClassVar[List[str]] = ["id", "name", "entity", "metric", "unit", "source", "frequency", "description", "labels", "observations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of QueryNlPost200ResponseSeriesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entity
        if self.entity:
            _dict['entity'] = self.entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metric
        if self.metric:
            _dict['metric'] = self.metric.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unit
        if self.unit:
            _dict['unit'] = self.unit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in observations (list)
        _items = []
        if self.observations:
            for _item_observations in self.observations:
                if _item_observations:
                    _items.append(_item_observations.to_dict())
            _dict['observations'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of QueryNlPost200ResponseSeriesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "entity": QueryNlPost200ResponseSeriesInnerEntity.from_dict(obj["entity"]) if obj.get("entity") is not None else None,
            "metric": QueryNlPost200ResponseSeriesInnerMetric.from_dict(obj["metric"]) if obj.get("metric") is not None else None,
            "unit": QueryNlPost200ResponseSeriesInnerUnit.from_dict(obj["unit"]) if obj.get("unit") is not None else None,
            "source": QueryNlPost200ResponseSeriesInnerSource.from_dict(obj["source"]) if obj.get("source") is not None else None,
            "frequency": obj.get("frequency"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "observations": [QueryNlPost200ResponseSeriesInnerObservationsInner.from_dict(_item) for _item in obj["observations"]] if obj.get("observations") is not None else None
        })
        return _obj


