# coding: utf-8

"""
    qoery's API

    Every number on the internet, queryable. Instant access to millions of trusted statistics through a single natural language query or API call.  # Installation  ### Python SDK  Install from PyPI:  ```bash pip install qoery ```  PyPI: [qoery](https://pypi.org/project/qoery/)  ### JavaScript SDK  Install from npm:  ```bash npm install qoery ```  npm: [qoery](https://www.npmjs.com/package/qoery) 

    The version of the OpenAPI document: 0.2.0
    Contact: samuel.tinnerholm@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from qoery.models.query_nl_post200_response_series_inner import QueryNlPost200ResponseSeriesInner
from qoery.models.scrape_post200_response_artifacts import ScrapePost200ResponseArtifacts
from qoery.models.scrape_post200_response_metadata import ScrapePost200ResponseMetadata
from typing import Optional, Set
from typing_extensions import Self

class ScrapeResponse(BaseModel):
    """
    Response from web scraping endpoint
    """ # noqa: E501
    series: List[QueryNlPost200ResponseSeriesInner] = Field(description="Array of series with observations (same structure as query endpoints)")
    artifacts: Optional[ScrapePost200ResponseArtifacts] = None
    cached: Optional[StrictBool] = Field(default=None, description="Whether this result was retrieved from cache")
    source_id: Optional[StrictStr] = Field(default=None, description="Database source ID (present when cached=true)")
    metadata: Optional[ScrapePost200ResponseMetadata] = None
    html: Optional[StrictStr] = Field(default=None, description="Original HTML of the page (only if html=true query param)")
    markdown: Optional[StrictStr] = Field(default=None, description="Markdown representation of the page (only if markdown=true query param)")
    __properties: ClassVar[List[str]] = ["series", "artifacts", "cached", "source_id", "metadata", "html", "markdown"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScrapeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in series (list)
        _items = []
        if self.series:
            for _item_series in self.series:
                if _item_series:
                    _items.append(_item_series.to_dict())
            _dict['series'] = _items
        # override the default output from pydantic by calling `to_dict()` of artifacts
        if self.artifacts:
            _dict['artifacts'] = self.artifacts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScrapeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "series": [QueryNlPost200ResponseSeriesInner.from_dict(_item) for _item in obj["series"]] if obj.get("series") is not None else None,
            "artifacts": ScrapePost200ResponseArtifacts.from_dict(obj["artifacts"]) if obj.get("artifacts") is not None else None,
            "cached": obj.get("cached"),
            "source_id": obj.get("source_id"),
            "metadata": ScrapePost200ResponseMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "html": obj.get("html"),
            "markdown": obj.get("markdown")
        })
        return _obj


