# coding: utf-8

"""
    qoery's API

    Every number on the internet, queryable. Instant access to millions of trusted statistics through a single natural language query or API call.  # Installation  ### Python SDK  Install from PyPI:  ```bash pip install qoery ```  PyPI: [qoery](https://pypi.org/project/qoery/)  ### JavaScript SDK  Install from npm:  ```bash npm install qoery ```  npm: [qoery](https://www.npmjs.com/package/qoery) 

    The version of the OpenAPI document: 0.2.0
    Contact: samuel.tinnerholm@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class UsageGet200ResponseEndpointsNl(BaseModel):
    """
    Usage statistics for a specific endpoint
    """ # noqa: E501
    calls_used: StrictInt = Field(description="Number of calls used in current period")
    calls_limit: StrictStr = Field(description="Maximum calls allowed in current period (returned as string)")
    tokens_in: StrictInt = Field(description="Total input tokens consumed in current period")
    tokens_out: StrictInt = Field(description="Total output tokens consumed in current period")
    errors: StrictInt = Field(description="Total number of errors in current period")
    remaining: StrictInt = Field(description="Number of calls remaining in current period")
    __properties: ClassVar[List[str]] = ["calls_used", "calls_limit", "tokens_in", "tokens_out", "errors", "remaining"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UsageGet200ResponseEndpointsNl from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UsageGet200ResponseEndpointsNl from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "calls_used": obj.get("calls_used"),
            "calls_limit": obj.get("calls_limit"),
            "tokens_in": obj.get("tokens_in"),
            "tokens_out": obj.get("tokens_out"),
            "errors": obj.get("errors"),
            "remaining": obj.get("remaining")
        })
        return _obj


