# ✨ Welcome to CosmoTalker v2 – Now Smarter, Broader, and Even More User-Friendly!

🚀 **CosmoTalker v2** is officially here!
Explore the **Solar System** and beyond with this **offline-Python library**, now enhanced with a **beta image preview tool**, **advanced search**, **user-friendly functions**, and **real-time space data**.

> ✅ Now ready for **Debian-based Linux systems** via `Cosmo4U`
> 📌 `.apk` for **Android** and `.exe` for **Windows** are rolling out soon!

---

## 🎐 What is CosmoTalker?

**CosmoTalker** is a Python library developed by **[Bhuvanesh M](https://github.com/bhuvanesh-m-dev)** to bring **space exploration, astronomy data, and scientific facts** directly to your system — no internet required for core features.

Perfect for **space lovers**, **students**, and **offline learners**. All core info is bundled with the module, while online features like space news and real-time updates extend the experience.

---

## 🚀 What's New in v2?

* 🦠 **Improved Solar System Module**
* 🔎 **Enhanced deep search algorithm**
* 📸 **Beta image function** to preview and save cosmic visuals
* 📖 **New wiki summary tool** with fetch speed tracking
* 🔭 **Cosmic event tracker** for SpaceX & satellite data
* 🌐 More intuitive commands for easier interaction

---

## 🔧 Features

* 🌍 Get planet data: `cosmotalker.get("mars")`
* 🔬 Learn science facts: `cosmotalker.get("gravity")`
* 🌐 Perform searches using eco-friendly search: `cosmotalker.search("your query")`
* 📡 Fetch space updates from CelesTrak, NASA APOD, SpaceX, and more
* 📷 Download astronomy images: `cosmotalker.img()` (beta)
* 💼 Wikipedia-powered summaries: `cosmotalker.wiki("black hole")`
* ✅ Works fully **offline** for core data

> 🌱 Eco-friendly search using **Ecosia** (supports tree planting)

---

## 🛆 Installation

```bash
pip install cosmotalker
```

> ✅ Compatible with Python 3.6+

### 🐿 Linux Users:

Install **Cosmo4U** for Debian-based distros (Ubuntu, Kali, Parrot):

Download Cosmo4U from the internet via this URL:
➡️ **[https://bhuvaneshm.in/cosmo4u](https://bhuvaneshm.in/cosmo4u)**

Enjoy Cosmo4U on your Debian system and explore the universe offline!

> 🛠️ Coming Soon:
>
> * 📱 `CosmoTalker.apk` for Android
> * 💻 `CosmoTalker.exe` for Windows

---

## 🧪 Usage Example

```python
import cosmotalker

print(cosmotalker.get("earth"))           # Offline solar system data
print(cosmotalker.feedback())             # Send feedback
print(cosmotalker.apod())                 # Astronomy Picture of the Day
print(cosmotalker.celestrak())            # Satellite tracking
print(cosmotalker.search("yt"))           # Open YouTube in browser
print(cosmotalker.search("words"))        # Eco-friendly web search and download Cosmo4U at bhuvaneshm.in/cosmo4u
print(cosmotalker.get("gravity"))         # Deep science query
print(cosmotalker.spacex())               # SpaceX launch data
print(cosmotalker.wiki("black hole"))     # Wikipedia summary
print(cosmotalker.img())                  # Image viewer (Beta)
```

> 💡 Use `cosmotalker.search()` shortcuts:
> `yt` = YouTube, `wa` = WhatsApp, `gpt` = ChatGPT, `insta`, `fb`, etc.

---

## 🚁 Benchmark Results

```
Offline Response Times:
0.00078s
0.00072s
0.00075s
0.00073s
...
```

---

## 🌐 Project Links

* 🔗 **Explore More**: [bhuvaneshm.in/cosmotalker](https://bhuvaneshm.in/cosmotalker)
* ⭐ **Star the Repo**: [github.com/bhuvanesh-m-dev/cosmotalker](https://github.com/bhuvanesh-m-dev/cosmotalker)

---

## 👨‍💻 Developed By

**Bhuvanesh M**
🚀 CSE Student | 🎐 Astronomy Enthusiast | 🐧 Linux Dev | 🐍 Python Coder

### 🔗 Connect:

* **Portfolio**: [bhuvaneshm.in](https://bhuvaneshm.in/)
* **GitHub**: [@bhuvanesh-m-dev](https://github.com/bhuvanesh-m-dev)
* **LinkedIn**: [bhuvaneshm-developer](https://linkedin.com/in/bhuvaneshm-developer)
* **HackerRank**: [bhuvaneshm\_dev](https://hackerrank.com/profile/bhuvaneshm_dev)
* **YouTube**: [@bhuvaneshm\_dev](https://youtube.com/@bhuvaneshm_dev)
* **LeetCode**: [bhuvaneshm\_dev](https://leetcode.com/u/bhuvaneshm_dev)
* **Dev.to**: [@bhuvaneshm\_dev](https://dev.to/bhuvaneshm_dev)
* **Twitter (X)**: [@bhuvaneshm06](https://x.com/bhuvaneshm06)
* **Instagram**: [@bhuvaneshm.developer](https://instagram.com/bhuvaneshm.developer)

---

## ✨ Update: `get()` Rebranded as `info()`

The `get()` function is being rebranded to `info()` in upcoming versions.

> 💡 The **new** `info()` **function** will offer:
>
> * Cleaner and more relevant results
> * Enhanced precision
> * Better support for scientific and factual queries

## 🌟 Introducing the Brand New `get()` Function!

🚀 CosmoTalker v2 now features the **revamped `get()` function**, designed to deliver **accurate answers** for your keyword queries in **milliseconds**! Whether you're exploring planets, scientific concepts, or cosmic phenomena, `get()` provides **precise, reliable results** with lightning-fast performance.

### ✨ Why `get()` Stands Out
- **Pinpoint Accuracy**: Returns the most relevant information for your keyword.
- **Blazing Speed**: Responses in ~0.0007 seconds, thanks to optimized offline data processing.
- **Versatile Queries**: Supports queries like planets (`get("mars")`), science facts (`get("gravity")`), and more.
- **Offline Ready**: Core data is bundled, so no internet is needed for most queries.

### 🧪 Example Usage
```python
import cosmotalker

print(cosmotalker.get("earth"))    # Instant data about Earth

###Stay tuned for future enhancements!

