/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleAccessApprovalOrganizationServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_access_approval_organization_service_account#id DataGoogleAccessApprovalOrganizationServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_access_approval_organization_service_account#organization_id DataGoogleAccessApprovalOrganizationServiceAccount#organization_id}
    */
    readonly organizationId: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_access_approval_organization_service_account google_access_approval_organization_service_account}
*/
export declare class DataGoogleAccessApprovalOrganizationServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_access_approval_organization_service_account";
    /**
    * Generates CDKTF code for importing a DataGoogleAccessApprovalOrganizationServiceAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleAccessApprovalOrganizationServiceAccount to import
    * @param importFromId The id of the existing DataGoogleAccessApprovalOrganizationServiceAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_access_approval_organization_service_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleAccessApprovalOrganizationServiceAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_access_approval_organization_service_account google_access_approval_organization_service_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleAccessApprovalOrganizationServiceAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleAccessApprovalOrganizationServiceAccountConfig);
    get accountEmail(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _organizationId?;
    get organizationId(): string;
    set organizationId(value: string);
    get organizationIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
