/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleAlloydbSupportedDatabaseFlagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_alloydb_supported_database_flags#id DataGoogleAlloydbSupportedDatabaseFlags#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The canonical id for the location. For example: "us-east1".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_alloydb_supported_database_flags#location DataGoogleAlloydbSupportedDatabaseFlags#location}
    */
    readonly location: string;
    /**
    * Project ID of the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_alloydb_supported_database_flags#project DataGoogleAlloydbSupportedDatabaseFlags#project}
    */
    readonly project?: string;
}
export interface DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictions {
}
export declare function dataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictionsToTerraform(struct?: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictions): any;
export declare function dataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictionsToHclTerraform(struct?: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictions): any;
export declare class DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictions | undefined;
    set internalValue(value: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictions | undefined);
    get maxValue(): string;
    get minValue(): string;
}
export declare class DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictionsOutputReference;
}
export interface DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictions {
}
export declare function dataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictionsToTerraform(struct?: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictions): any;
export declare function dataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictionsToHclTerraform(struct?: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictions): any;
export declare class DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictions | undefined;
    set internalValue(value: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictions | undefined);
    get allowedValues(): string[];
}
export declare class DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictionsOutputReference;
}
export interface DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlags {
}
export declare function dataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsToTerraform(struct?: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlags): any;
export declare function dataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsToHclTerraform(struct?: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlags): any;
export declare class DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlags | undefined;
    set internalValue(value: DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlags | undefined);
    get acceptsMultipleValues(): cdktf.IResolvable;
    get flagName(): string;
    private _integerRestrictions;
    get integerRestrictions(): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsIntegerRestrictionsList;
    get name(): string;
    get requiresDbRestart(): cdktf.IResolvable;
    private _stringRestrictions;
    get stringRestrictions(): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsStringRestrictionsList;
    get supportedDbVersions(): string[];
    get valueType(): string;
}
export declare class DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_alloydb_supported_database_flags google_alloydb_supported_database_flags}
*/
export declare class DataGoogleAlloydbSupportedDatabaseFlags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_alloydb_supported_database_flags";
    /**
    * Generates CDKTF code for importing a DataGoogleAlloydbSupportedDatabaseFlags resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleAlloydbSupportedDatabaseFlags to import
    * @param importFromId The id of the existing DataGoogleAlloydbSupportedDatabaseFlags that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_alloydb_supported_database_flags#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleAlloydbSupportedDatabaseFlags to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_alloydb_supported_database_flags google_alloydb_supported_database_flags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleAlloydbSupportedDatabaseFlagsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleAlloydbSupportedDatabaseFlagsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _supportedDatabaseFlags;
    get supportedDatabaseFlags(): DataGoogleAlloydbSupportedDatabaseFlagsSupportedDatabaseFlagsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
