/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleApphubDiscoveredServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service#id DataGoogleApphubDiscoveredService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service#location DataGoogleApphubDiscoveredService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service#project DataGoogleApphubDiscoveredService#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service#service_uri DataGoogleApphubDiscoveredService#service_uri}
    */
    readonly serviceUri: string;
}
export interface DataGoogleApphubDiscoveredServiceServiceProperties {
}
export declare function dataGoogleApphubDiscoveredServiceServicePropertiesToTerraform(struct?: DataGoogleApphubDiscoveredServiceServiceProperties): any;
export declare function dataGoogleApphubDiscoveredServiceServicePropertiesToHclTerraform(struct?: DataGoogleApphubDiscoveredServiceServiceProperties): any;
export declare class DataGoogleApphubDiscoveredServiceServicePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleApphubDiscoveredServiceServiceProperties | undefined;
    set internalValue(value: DataGoogleApphubDiscoveredServiceServiceProperties | undefined);
    get gcpProject(): string;
    get location(): string;
    get zone(): string;
}
export declare class DataGoogleApphubDiscoveredServiceServicePropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleApphubDiscoveredServiceServicePropertiesOutputReference;
}
export interface DataGoogleApphubDiscoveredServiceServiceReference {
}
export declare function dataGoogleApphubDiscoveredServiceServiceReferenceToTerraform(struct?: DataGoogleApphubDiscoveredServiceServiceReference): any;
export declare function dataGoogleApphubDiscoveredServiceServiceReferenceToHclTerraform(struct?: DataGoogleApphubDiscoveredServiceServiceReference): any;
export declare class DataGoogleApphubDiscoveredServiceServiceReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleApphubDiscoveredServiceServiceReference | undefined;
    set internalValue(value: DataGoogleApphubDiscoveredServiceServiceReference | undefined);
    get path(): string;
    get uri(): string;
}
export declare class DataGoogleApphubDiscoveredServiceServiceReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleApphubDiscoveredServiceServiceReferenceOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service google_apphub_discovered_service}
*/
export declare class DataGoogleApphubDiscoveredService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_apphub_discovered_service";
    /**
    * Generates CDKTF code for importing a DataGoogleApphubDiscoveredService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleApphubDiscoveredService to import
    * @param importFromId The id of the existing DataGoogleApphubDiscoveredService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleApphubDiscoveredService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_apphub_discovered_service google_apphub_discovered_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleApphubDiscoveredServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleApphubDiscoveredServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceProperties;
    get serviceProperties(): DataGoogleApphubDiscoveredServiceServicePropertiesList;
    private _serviceReference;
    get serviceReference(): DataGoogleApphubDiscoveredServiceServiceReferenceList;
    private _serviceUri?;
    get serviceUri(): string;
    set serviceUri(value: string);
    get serviceUriInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
