/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBackupDrManagementServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_backup_dr_management_server#id DataGoogleBackupDrManagementServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the management server (management console)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_backup_dr_management_server#location DataGoogleBackupDrManagementServer#location}
    */
    readonly location: string;
}
export interface DataGoogleBackupDrManagementServerManagementUri {
}
export declare function dataGoogleBackupDrManagementServerManagementUriToTerraform(struct?: DataGoogleBackupDrManagementServerManagementUri): any;
export declare function dataGoogleBackupDrManagementServerManagementUriToHclTerraform(struct?: DataGoogleBackupDrManagementServerManagementUri): any;
export declare class DataGoogleBackupDrManagementServerManagementUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBackupDrManagementServerManagementUri | undefined;
    set internalValue(value: DataGoogleBackupDrManagementServerManagementUri | undefined);
    get api(): string;
    get webUi(): string;
}
export declare class DataGoogleBackupDrManagementServerManagementUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBackupDrManagementServerManagementUriOutputReference;
}
export interface DataGoogleBackupDrManagementServerNetworks {
}
export declare function dataGoogleBackupDrManagementServerNetworksToTerraform(struct?: DataGoogleBackupDrManagementServerNetworks): any;
export declare function dataGoogleBackupDrManagementServerNetworksToHclTerraform(struct?: DataGoogleBackupDrManagementServerNetworks): any;
export declare class DataGoogleBackupDrManagementServerNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBackupDrManagementServerNetworks | undefined;
    set internalValue(value: DataGoogleBackupDrManagementServerNetworks | undefined);
    get network(): string;
    get peeringMode(): string;
}
export declare class DataGoogleBackupDrManagementServerNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBackupDrManagementServerNetworksOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_backup_dr_management_server google_backup_dr_management_server}
*/
export declare class DataGoogleBackupDrManagementServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_backup_dr_management_server";
    /**
    * Generates CDKTF code for importing a DataGoogleBackupDrManagementServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleBackupDrManagementServer to import
    * @param importFromId The id of the existing DataGoogleBackupDrManagementServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_backup_dr_management_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleBackupDrManagementServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_backup_dr_management_server google_backup_dr_management_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBackupDrManagementServerConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleBackupDrManagementServerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managementUri;
    get managementUri(): DataGoogleBackupDrManagementServerManagementUriList;
    get name(): string;
    private _networks;
    get networks(): DataGoogleBackupDrManagementServerNetworksList;
    get oauth2ClientId(): string;
    get project(): string;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
