/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBeyondcorpAppConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection#id DataGoogleBeyondcorpAppConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection#name DataGoogleBeyondcorpAppConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection#project DataGoogleBeyondcorpAppConnection#project}
    */
    readonly project?: string;
    /**
    * The region of the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection#region DataGoogleBeyondcorpAppConnection#region}
    */
    readonly region?: string;
}
export interface DataGoogleBeyondcorpAppConnectionApplicationEndpoint {
}
export declare function dataGoogleBeyondcorpAppConnectionApplicationEndpointToTerraform(struct?: DataGoogleBeyondcorpAppConnectionApplicationEndpoint): any;
export declare function dataGoogleBeyondcorpAppConnectionApplicationEndpointToHclTerraform(struct?: DataGoogleBeyondcorpAppConnectionApplicationEndpoint): any;
export declare class DataGoogleBeyondcorpAppConnectionApplicationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBeyondcorpAppConnectionApplicationEndpoint | undefined;
    set internalValue(value: DataGoogleBeyondcorpAppConnectionApplicationEndpoint | undefined);
    get host(): string;
    get port(): number;
}
export declare class DataGoogleBeyondcorpAppConnectionApplicationEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBeyondcorpAppConnectionApplicationEndpointOutputReference;
}
export interface DataGoogleBeyondcorpAppConnectionGateway {
}
export declare function dataGoogleBeyondcorpAppConnectionGatewayToTerraform(struct?: DataGoogleBeyondcorpAppConnectionGateway): any;
export declare function dataGoogleBeyondcorpAppConnectionGatewayToHclTerraform(struct?: DataGoogleBeyondcorpAppConnectionGateway): any;
export declare class DataGoogleBeyondcorpAppConnectionGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBeyondcorpAppConnectionGateway | undefined;
    set internalValue(value: DataGoogleBeyondcorpAppConnectionGateway | undefined);
    get appGateway(): string;
    get ingressPort(): number;
    get type(): string;
    get uri(): string;
}
export declare class DataGoogleBeyondcorpAppConnectionGatewayList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBeyondcorpAppConnectionGatewayOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection google_beyondcorp_app_connection}
*/
export declare class DataGoogleBeyondcorpAppConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_beyondcorp_app_connection";
    /**
    * Generates CDKTF code for importing a DataGoogleBeyondcorpAppConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleBeyondcorpAppConnection to import
    * @param importFromId The id of the existing DataGoogleBeyondcorpAppConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleBeyondcorpAppConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_beyondcorp_app_connection google_beyondcorp_app_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBeyondcorpAppConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleBeyondcorpAppConnectionConfig);
    private _applicationEndpoint;
    get applicationEndpoint(): DataGoogleBeyondcorpAppConnectionApplicationEndpointList;
    get connectors(): string[];
    get displayName(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gateway;
    get gateway(): DataGoogleBeyondcorpAppConnectionGatewayList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
