/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy#data_exchange_id DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy#data_exchange_id}
    */
    readonly dataExchangeId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy#id DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy#location DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy#project DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy google_bigquery_analytics_hub_data_exchange_iam_policy}
*/
export declare class DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_bigquery_analytics_hub_data_exchange_iam_policy";
    /**
    * Generates CDKTF code for importing a DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy to import
    * @param importFromId The id of the existing DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_analytics_hub_data_exchange_iam_policy google_bigquery_analytics_hub_data_exchange_iam_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleBigqueryAnalyticsHubDataExchangeIamPolicyConfig);
    private _dataExchangeId?;
    get dataExchangeId(): string;
    set dataExchangeId(value: string);
    get dataExchangeIdInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get policyData(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
