/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBigqueryDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique ID for this dataset, without the project name. The ID
    * must contain only letters (a-z, A-Z), numbers (0-9), or
    * underscores (_). The maximum length is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_dataset#dataset_id DataGoogleBigqueryDataset#dataset_id}
    */
    readonly datasetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_dataset#id DataGoogleBigqueryDataset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_dataset#project DataGoogleBigqueryDataset#project}
    */
    readonly project?: string;
}
export interface DataGoogleBigqueryDatasetAccessDatasetDataset {
}
export declare function dataGoogleBigqueryDatasetAccessDatasetDatasetToTerraform(struct?: DataGoogleBigqueryDatasetAccessDatasetDataset): any;
export declare function dataGoogleBigqueryDatasetAccessDatasetDatasetToHclTerraform(struct?: DataGoogleBigqueryDatasetAccessDatasetDataset): any;
export declare class DataGoogleBigqueryDatasetAccessDatasetDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetAccessDatasetDataset | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetAccessDatasetDataset | undefined);
    get datasetId(): string;
    get projectId(): string;
}
export declare class DataGoogleBigqueryDatasetAccessDatasetDatasetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetAccessDatasetDatasetOutputReference;
}
export interface DataGoogleBigqueryDatasetAccessDataset {
}
export declare function dataGoogleBigqueryDatasetAccessDatasetToTerraform(struct?: DataGoogleBigqueryDatasetAccessDataset): any;
export declare function dataGoogleBigqueryDatasetAccessDatasetToHclTerraform(struct?: DataGoogleBigqueryDatasetAccessDataset): any;
export declare class DataGoogleBigqueryDatasetAccessDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetAccessDataset | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetAccessDataset | undefined);
    private _dataset;
    get dataset(): DataGoogleBigqueryDatasetAccessDatasetDatasetList;
    get targetTypes(): string[];
}
export declare class DataGoogleBigqueryDatasetAccessDatasetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetAccessDatasetOutputReference;
}
export interface DataGoogleBigqueryDatasetAccessRoutine {
}
export declare function dataGoogleBigqueryDatasetAccessRoutineToTerraform(struct?: DataGoogleBigqueryDatasetAccessRoutine): any;
export declare function dataGoogleBigqueryDatasetAccessRoutineToHclTerraform(struct?: DataGoogleBigqueryDatasetAccessRoutine): any;
export declare class DataGoogleBigqueryDatasetAccessRoutineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetAccessRoutine | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetAccessRoutine | undefined);
    get datasetId(): string;
    get projectId(): string;
    get routineId(): string;
}
export declare class DataGoogleBigqueryDatasetAccessRoutineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetAccessRoutineOutputReference;
}
export interface DataGoogleBigqueryDatasetAccessView {
}
export declare function dataGoogleBigqueryDatasetAccessViewToTerraform(struct?: DataGoogleBigqueryDatasetAccessView): any;
export declare function dataGoogleBigqueryDatasetAccessViewToHclTerraform(struct?: DataGoogleBigqueryDatasetAccessView): any;
export declare class DataGoogleBigqueryDatasetAccessViewOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetAccessView | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetAccessView | undefined);
    get datasetId(): string;
    get projectId(): string;
    get tableId(): string;
}
export declare class DataGoogleBigqueryDatasetAccessViewList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetAccessViewOutputReference;
}
export interface DataGoogleBigqueryDatasetAccess {
}
export declare function dataGoogleBigqueryDatasetAccessToTerraform(struct?: DataGoogleBigqueryDatasetAccess): any;
export declare function dataGoogleBigqueryDatasetAccessToHclTerraform(struct?: DataGoogleBigqueryDatasetAccess): any;
export declare class DataGoogleBigqueryDatasetAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetAccess | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetAccess | undefined);
    private _dataset;
    get dataset(): DataGoogleBigqueryDatasetAccessDatasetList;
    get domain(): string;
    get groupByEmail(): string;
    get iamMember(): string;
    get role(): string;
    private _routine;
    get routine(): DataGoogleBigqueryDatasetAccessRoutineList;
    get specialGroup(): string;
    get userByEmail(): string;
    private _view;
    get view(): DataGoogleBigqueryDatasetAccessViewList;
}
export declare class DataGoogleBigqueryDatasetAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetAccessOutputReference;
}
export interface DataGoogleBigqueryDatasetDefaultEncryptionConfiguration {
}
export declare function dataGoogleBigqueryDatasetDefaultEncryptionConfigurationToTerraform(struct?: DataGoogleBigqueryDatasetDefaultEncryptionConfiguration): any;
export declare function dataGoogleBigqueryDatasetDefaultEncryptionConfigurationToHclTerraform(struct?: DataGoogleBigqueryDatasetDefaultEncryptionConfiguration): any;
export declare class DataGoogleBigqueryDatasetDefaultEncryptionConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetDefaultEncryptionConfiguration | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetDefaultEncryptionConfiguration | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleBigqueryDatasetDefaultEncryptionConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetDefaultEncryptionConfigurationOutputReference;
}
export interface DataGoogleBigqueryDatasetExternalDatasetReference {
}
export declare function dataGoogleBigqueryDatasetExternalDatasetReferenceToTerraform(struct?: DataGoogleBigqueryDatasetExternalDatasetReference): any;
export declare function dataGoogleBigqueryDatasetExternalDatasetReferenceToHclTerraform(struct?: DataGoogleBigqueryDatasetExternalDatasetReference): any;
export declare class DataGoogleBigqueryDatasetExternalDatasetReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleBigqueryDatasetExternalDatasetReference | undefined;
    set internalValue(value: DataGoogleBigqueryDatasetExternalDatasetReference | undefined);
    get connection(): string;
    get externalSource(): string;
}
export declare class DataGoogleBigqueryDatasetExternalDatasetReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleBigqueryDatasetExternalDatasetReferenceOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_dataset google_bigquery_dataset}
*/
export declare class DataGoogleBigqueryDataset extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_bigquery_dataset";
    /**
    * Generates CDKTF code for importing a DataGoogleBigqueryDataset resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleBigqueryDataset to import
    * @param importFromId The id of the existing DataGoogleBigqueryDataset that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_dataset#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleBigqueryDataset to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_bigquery_dataset google_bigquery_dataset} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBigqueryDatasetConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleBigqueryDatasetConfig);
    private _access;
    get access(): DataGoogleBigqueryDatasetAccessList;
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    get defaultCollation(): string;
    private _defaultEncryptionConfiguration;
    get defaultEncryptionConfiguration(): DataGoogleBigqueryDatasetDefaultEncryptionConfigurationList;
    get defaultPartitionExpirationMs(): number;
    get defaultTableExpirationMs(): number;
    get deleteContentsOnDestroy(): cdktf.IResolvable;
    get description(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _externalDatasetReference;
    get externalDatasetReference(): DataGoogleBigqueryDatasetExternalDatasetReferenceList;
    get friendlyName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isCaseInsensitive(): cdktf.IResolvable;
    private _labels;
    get labels(): cdktf.StringMap;
    get lastModifiedTime(): number;
    get location(): string;
    get maxTimeTravelHours(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get storageBillingModel(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
