/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleBillingAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account#billing_account DataGoogleBillingAccount#billing_account}
    */
    readonly billingAccount?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account#display_name DataGoogleBillingAccount#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account#id DataGoogleBillingAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account#lookup_projects DataGoogleBillingAccount#lookup_projects}
    */
    readonly lookupProjects?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account#open DataGoogleBillingAccount#open}
    */
    readonly open?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account google_billing_account}
*/
export declare class DataGoogleBillingAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_billing_account";
    /**
    * Generates CDKTF code for importing a DataGoogleBillingAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleBillingAccount to import
    * @param importFromId The id of the existing DataGoogleBillingAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleBillingAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_billing_account google_billing_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleBillingAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleBillingAccountConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    resetBillingAccount(): void;
    get billingAccountInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _lookupProjects?;
    get lookupProjects(): boolean | cdktf.IResolvable;
    set lookupProjects(value: boolean | cdktf.IResolvable);
    resetLookupProjects(): void;
    get lookupProjectsInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _open?;
    get open(): boolean | cdktf.IResolvable;
    set open(value: boolean | cdktf.IResolvable);
    resetOpen(): void;
    get openInput(): boolean | cdktf.IResolvable | undefined;
    get projectIds(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
