/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCertificateManagerCertificateMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_certificate_manager_certificate_map#id DataGoogleCertificateManagerCertificateMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A user-defined name of the Certificate Map. Certificate Map names must be unique
    * globally and match the pattern 'projects/* /locations/* /certificateMaps/*'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_certificate_manager_certificate_map#name DataGoogleCertificateManagerCertificateMap#name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_certificate_manager_certificate_map#project DataGoogleCertificateManagerCertificateMap#project}
    */
    readonly project?: string;
}
export interface DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigs {
}
export declare function dataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigsToTerraform(struct?: DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigs): any;
export declare function dataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigsToHclTerraform(struct?: DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigs): any;
export declare class DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigs | undefined;
    set internalValue(value: DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigs | undefined);
    get ipAddress(): string;
    get ports(): number[];
}
export declare class DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigsOutputReference;
}
export interface DataGoogleCertificateManagerCertificateMapGclbTargets {
}
export declare function dataGoogleCertificateManagerCertificateMapGclbTargetsToTerraform(struct?: DataGoogleCertificateManagerCertificateMapGclbTargets): any;
export declare function dataGoogleCertificateManagerCertificateMapGclbTargetsToHclTerraform(struct?: DataGoogleCertificateManagerCertificateMapGclbTargets): any;
export declare class DataGoogleCertificateManagerCertificateMapGclbTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCertificateManagerCertificateMapGclbTargets | undefined;
    set internalValue(value: DataGoogleCertificateManagerCertificateMapGclbTargets | undefined);
    private _ipConfigs;
    get ipConfigs(): DataGoogleCertificateManagerCertificateMapGclbTargetsIpConfigsList;
    get targetHttpsProxy(): string;
    get targetSslProxy(): string;
}
export declare class DataGoogleCertificateManagerCertificateMapGclbTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCertificateManagerCertificateMapGclbTargetsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_certificate_manager_certificate_map google_certificate_manager_certificate_map}
*/
export declare class DataGoogleCertificateManagerCertificateMap extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_certificate_manager_certificate_map";
    /**
    * Generates CDKTF code for importing a DataGoogleCertificateManagerCertificateMap resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleCertificateManagerCertificateMap to import
    * @param importFromId The id of the existing DataGoogleCertificateManagerCertificateMap that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_certificate_manager_certificate_map#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleCertificateManagerCertificateMap to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_certificate_manager_certificate_map google_certificate_manager_certificate_map} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCertificateManagerCertificateMapConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCertificateManagerCertificateMapConfig);
    get createTime(): string;
    get description(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _gclbTargets;
    get gclbTargets(): DataGoogleCertificateManagerCertificateMapGclbTargetsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
