/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleClientOpenidUserinfoConfig extends cdktf.TerraformMetaArguments {
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_client_openid_userinfo google_client_openid_userinfo}
*/
export declare class DataGoogleClientOpenidUserinfo extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_client_openid_userinfo";
    /**
    * Generates CDKTF code for importing a DataGoogleClientOpenidUserinfo resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleClientOpenidUserinfo to import
    * @param importFromId The id of the existing DataGoogleClientOpenidUserinfo that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_client_openid_userinfo#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleClientOpenidUserinfo to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_client_openid_userinfo google_client_openid_userinfo} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleClientOpenidUserinfoConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleClientOpenidUserinfoConfig);
    get email(): string;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
