/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudIdentityGroupLookupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup#id DataGoogleCloudIdentityGroupLookup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * group_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup#group_key DataGoogleCloudIdentityGroupLookup#group_key}
    */
    readonly groupKey: DataGoogleCloudIdentityGroupLookupGroupKey;
}
export interface DataGoogleCloudIdentityGroupLookupGroupKey {
    /**
    * The ID of the entity. For Google-managed entities, the id should be the email address of an existing group or user.
    * For external-identity-mapped entities, the id must be a string conforming to the Identity Source's requirements.
    * Must be unique within a namespace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup#id DataGoogleCloudIdentityGroupLookup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * The namespace in which the entity exists. If not specified, the EntityKey represents a Google-managed entity such as a Google user or a Google Group.
    * If specified, the EntityKey represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of identitysources/{identity_source}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup#namespace DataGoogleCloudIdentityGroupLookup#namespace}
    */
    readonly namespace?: string;
}
export declare function dataGoogleCloudIdentityGroupLookupGroupKeyToTerraform(struct?: DataGoogleCloudIdentityGroupLookupGroupKeyOutputReference | DataGoogleCloudIdentityGroupLookupGroupKey): any;
export declare function dataGoogleCloudIdentityGroupLookupGroupKeyToHclTerraform(struct?: DataGoogleCloudIdentityGroupLookupGroupKeyOutputReference | DataGoogleCloudIdentityGroupLookupGroupKey): any;
export declare class DataGoogleCloudIdentityGroupLookupGroupKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataGoogleCloudIdentityGroupLookupGroupKey | undefined;
    set internalValue(value: DataGoogleCloudIdentityGroupLookupGroupKey | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup google_cloud_identity_group_lookup}
*/
export declare class DataGoogleCloudIdentityGroupLookup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_identity_group_lookup";
    /**
    * Generates CDKTF code for importing a DataGoogleCloudIdentityGroupLookup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleCloudIdentityGroupLookup to import
    * @param importFromId The id of the existing DataGoogleCloudIdentityGroupLookup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleCloudIdentityGroupLookup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_identity_group_lookup google_cloud_identity_group_lookup} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudIdentityGroupLookupConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupLookupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _groupKey;
    get groupKey(): DataGoogleCloudIdentityGroupLookupGroupKeyOutputReference;
    putGroupKey(value: DataGoogleCloudIdentityGroupLookupGroupKey): void;
    get groupKeyInput(): DataGoogleCloudIdentityGroupLookupGroupKey | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
