/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudQuotasQuotaInfoConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info#id DataGoogleCloudQuotasQuotaInfo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info#parent DataGoogleCloudQuotasQuotaInfo#parent}
    */
    readonly parent: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info#quota_id DataGoogleCloudQuotasQuotaInfo#quota_id}
    */
    readonly quotaId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info#service DataGoogleCloudQuotasQuotaInfo#service}
    */
    readonly service: string;
}
export interface DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetails {
}
export declare function dataGoogleCloudQuotasQuotaInfoDimensionsInfosDetailsToTerraform(struct?: DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetails): any;
export declare function dataGoogleCloudQuotasQuotaInfoDimensionsInfosDetailsToHclTerraform(struct?: DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetails): any;
export declare class DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetails | undefined;
    set internalValue(value: DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetails | undefined);
    get value(): string;
}
export declare class DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetailsOutputReference;
}
export interface DataGoogleCloudQuotasQuotaInfoDimensionsInfos {
}
export declare function dataGoogleCloudQuotasQuotaInfoDimensionsInfosToTerraform(struct?: DataGoogleCloudQuotasQuotaInfoDimensionsInfos): any;
export declare function dataGoogleCloudQuotasQuotaInfoDimensionsInfosToHclTerraform(struct?: DataGoogleCloudQuotasQuotaInfoDimensionsInfos): any;
export declare class DataGoogleCloudQuotasQuotaInfoDimensionsInfosOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudQuotasQuotaInfoDimensionsInfos | undefined;
    set internalValue(value: DataGoogleCloudQuotasQuotaInfoDimensionsInfos | undefined);
    get applicableLocations(): string[];
    private _details;
    get details(): DataGoogleCloudQuotasQuotaInfoDimensionsInfosDetailsList;
    private _dimensions;
    get dimensions(): cdktf.StringMap;
}
export declare class DataGoogleCloudQuotasQuotaInfoDimensionsInfosList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudQuotasQuotaInfoDimensionsInfosOutputReference;
}
export interface DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibility {
}
export declare function dataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibilityToTerraform(struct?: DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibility): any;
export declare function dataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibilityToHclTerraform(struct?: DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibility): any;
export declare class DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibility | undefined;
    set internalValue(value: DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibility | undefined);
    get ineligibilityReason(): string;
    get isEligible(): cdktf.IResolvable;
}
export declare class DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibilityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibilityOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info google_cloud_quotas_quota_info}
*/
export declare class DataGoogleCloudQuotasQuotaInfo extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_quotas_quota_info";
    /**
    * Generates CDKTF code for importing a DataGoogleCloudQuotasQuotaInfo resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleCloudQuotasQuotaInfo to import
    * @param importFromId The id of the existing DataGoogleCloudQuotasQuotaInfo that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleCloudQuotasQuotaInfo to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_quotas_quota_info google_cloud_quotas_quota_info} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudQuotasQuotaInfoConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudQuotasQuotaInfoConfig);
    get containerType(): string;
    get dimensions(): string[];
    private _dimensionsInfos;
    get dimensionsInfos(): DataGoogleCloudQuotasQuotaInfoDimensionsInfosList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isConcurrent(): cdktf.IResolvable;
    get isFixed(): cdktf.IResolvable;
    get isPrecise(): cdktf.IResolvable;
    get metric(): string;
    get metricDisplayName(): string;
    get metricUnit(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get quotaDisplayName(): string;
    private _quotaId?;
    get quotaId(): string;
    set quotaId(value: string);
    get quotaIdInput(): string | undefined;
    private _quotaIncreaseEligibility;
    get quotaIncreaseEligibility(): DataGoogleCloudQuotasQuotaInfoQuotaIncreaseEligibilityList;
    get refreshInterval(): string;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    get serviceRequestQuotaUri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
