/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service#id DataGoogleCloudRunService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service#location DataGoogleCloudRunService#location}
    */
    readonly location: string;
    /**
    * Name must be unique within a Google Cloud project and region.
    * Is required when creating resources. Name is primarily intended
    * for creation idempotence and configuration definition. Cannot be updated.
    * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service#name DataGoogleCloudRunService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service#project DataGoogleCloudRunService#project}
    */
    readonly project?: string;
}
export interface DataGoogleCloudRunServiceMetadata {
}
export declare function dataGoogleCloudRunServiceMetadataToTerraform(struct?: DataGoogleCloudRunServiceMetadata): any;
export declare function dataGoogleCloudRunServiceMetadataToHclTerraform(struct?: DataGoogleCloudRunServiceMetadata): any;
export declare class DataGoogleCloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceMetadata | undefined;
    set internalValue(value: DataGoogleCloudRunServiceMetadata | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get generation(): number;
    private _labels;
    get labels(): cdktf.StringMap;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceMetadataOutputReference;
}
export interface DataGoogleCloudRunServiceStatusConditions {
}
export declare function dataGoogleCloudRunServiceStatusConditionsToTerraform(struct?: DataGoogleCloudRunServiceStatusConditions): any;
export declare function dataGoogleCloudRunServiceStatusConditionsToHclTerraform(struct?: DataGoogleCloudRunServiceStatusConditions): any;
export declare class DataGoogleCloudRunServiceStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceStatusConditions | undefined;
    set internalValue(value: DataGoogleCloudRunServiceStatusConditions | undefined);
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunServiceStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceStatusConditionsOutputReference;
}
export interface DataGoogleCloudRunServiceStatusTraffic {
}
export declare function dataGoogleCloudRunServiceStatusTrafficToTerraform(struct?: DataGoogleCloudRunServiceStatusTraffic): any;
export declare function dataGoogleCloudRunServiceStatusTrafficToHclTerraform(struct?: DataGoogleCloudRunServiceStatusTraffic): any;
export declare class DataGoogleCloudRunServiceStatusTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceStatusTraffic | undefined;
    set internalValue(value: DataGoogleCloudRunServiceStatusTraffic | undefined);
    get latestRevision(): cdktf.IResolvable;
    get percent(): number;
    get revisionName(): string;
    get tag(): string;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceStatusTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceStatusTrafficOutputReference;
}
export interface DataGoogleCloudRunServiceStatus {
}
export declare function dataGoogleCloudRunServiceStatusToTerraform(struct?: DataGoogleCloudRunServiceStatus): any;
export declare function dataGoogleCloudRunServiceStatusToHclTerraform(struct?: DataGoogleCloudRunServiceStatus): any;
export declare class DataGoogleCloudRunServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceStatus | undefined;
    set internalValue(value: DataGoogleCloudRunServiceStatus | undefined);
    private _conditions;
    get conditions(): DataGoogleCloudRunServiceStatusConditionsList;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    private _traffic;
    get traffic(): DataGoogleCloudRunServiceStatusTrafficList;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceStatusOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateMetadata {
}
export declare function dataGoogleCloudRunServiceTemplateMetadataToTerraform(struct?: DataGoogleCloudRunServiceTemplateMetadata): any;
export declare function dataGoogleCloudRunServiceTemplateMetadataToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateMetadata): any;
export declare class DataGoogleCloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateMetadata | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateMetadata | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    get generation(): number;
    private _labels;
    get labels(): cdktf.StringMap;
    get name(): string;
    get namespace(): string;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export declare class DataGoogleCloudRunServiceTemplateMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateMetadataOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined);
    get key(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFrom | undefined);
    private _secretKeyRef;
    get secretKeyRef(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnv {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnv): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnv): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnv | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnv | undefined);
    get name(): string;
    get value(): string;
    private _valueFrom;
    get valueFrom(): DataGoogleCloudRunServiceTemplateSpecContainersEnvValueFromList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined);
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined);
    private _localObjectReference;
    get localObjectReference(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceList;
    get optional(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined);
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined);
    private _localObjectReference;
    get localObjectReference(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceList;
    get optional(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersEnvFromToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersEnvFrom | undefined);
    private _configMapRef;
    get configMapRef(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromConfigMapRefList;
    get prefix(): string;
    private _secretRef;
    get secretRef(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromSecretRefList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpc | undefined);
    get port(): number;
    get service(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeaders | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGet | undefined);
    private _httpHeaders;
    get httpHeaders(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetHttpHeadersList;
    get path(): string;
    get port(): number;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbe {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbe): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbe): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbe | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbe | undefined);
    get failureThreshold(): number;
    private _grpc;
    get grpc(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeGrpcList;
    private _httpGet;
    get httpGet(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeHttpGetList;
    get initialDelaySeconds(): number;
    get periodSeconds(): number;
    get timeoutSeconds(): number;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersPorts {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersPortsToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersPorts): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersPortsToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersPorts): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersPorts | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersPorts | undefined);
    get containerPort(): number;
    get name(): string;
    get protocol(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersPortsOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersResources {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersResourcesToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersResources): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersResourcesToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersResources): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersResources | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersResources | undefined);
    private _limits;
    get limits(): cdktf.StringMap;
    private _requests;
    get requests(): cdktf.StringMap;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersResourcesOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpc | undefined);
    get port(): number;
    get service(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeaders | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGet | undefined);
    private _httpHeaders;
    get httpHeaders(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetHttpHeadersList;
    get path(): string;
    get port(): number;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocket | undefined);
    get port(): number;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersStartupProbe {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbe): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersStartupProbeToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbe): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbe | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersStartupProbe | undefined);
    get failureThreshold(): number;
    private _grpc;
    get grpc(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeGrpcList;
    private _httpGet;
    get httpGet(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeHttpGetList;
    get initialDelaySeconds(): number;
    get periodSeconds(): number;
    private _tcpSocket;
    get tcpSocket(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeTcpSocketList;
    get timeoutSeconds(): number;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainersVolumeMounts | undefined);
    get mountPath(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecContainers {
}
export declare function dataGoogleCloudRunServiceTemplateSpecContainersToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainers): any;
export declare function dataGoogleCloudRunServiceTemplateSpecContainersToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecContainers): any;
export declare class DataGoogleCloudRunServiceTemplateSpecContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecContainers | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecContainers | undefined);
    get args(): string[];
    get command(): string[];
    private _env;
    get env(): DataGoogleCloudRunServiceTemplateSpecContainersEnvList;
    private _envFrom;
    get envFrom(): DataGoogleCloudRunServiceTemplateSpecContainersEnvFromList;
    get image(): string;
    private _livenessProbe;
    get livenessProbe(): DataGoogleCloudRunServiceTemplateSpecContainersLivenessProbeList;
    get name(): string;
    private _ports;
    get ports(): DataGoogleCloudRunServiceTemplateSpecContainersPortsList;
    private _resources;
    get resources(): DataGoogleCloudRunServiceTemplateSpecContainersResourcesList;
    private _startupProbe;
    get startupProbe(): DataGoogleCloudRunServiceTemplateSpecContainersStartupProbeList;
    private _volumeMounts;
    get volumeMounts(): DataGoogleCloudRunServiceTemplateSpecContainersVolumeMountsList;
    get workingDir(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecContainersOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumesCsi {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesCsiToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesCsi): any;
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesCsiToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesCsi): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesCsiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumesCsi | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumesCsi | undefined);
    get driver(): string;
    get readOnly(): cdktf.IResolvable;
    private _volumeAttributes;
    get volumeAttributes(): cdktf.StringMap;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesCsiList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesCsiOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDir {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesEmptyDirToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDir): any;
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesEmptyDirToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDir): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDir | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDir | undefined);
    get medium(): string;
    get sizeLimit(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDirList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDirOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems): any;
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumesSecretItems | undefined);
    get key(): string;
    get mode(): number;
    get path(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumesSecret {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesSecretToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesSecret): any;
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesSecretToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumesSecret): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumesSecret | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumesSecret | undefined);
    get defaultMode(): number;
    private _items;
    get items(): DataGoogleCloudRunServiceTemplateSpecVolumesSecretItemsList;
    get secretName(): string;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesSecretOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpecVolumes {
}
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumes): any;
export declare function dataGoogleCloudRunServiceTemplateSpecVolumesToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpecVolumes): any;
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpecVolumes | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpecVolumes | undefined);
    private _csi;
    get csi(): DataGoogleCloudRunServiceTemplateSpecVolumesCsiList;
    private _emptyDir;
    get emptyDir(): DataGoogleCloudRunServiceTemplateSpecVolumesEmptyDirList;
    get name(): string;
    private _secret;
    get secret(): DataGoogleCloudRunServiceTemplateSpecVolumesSecretList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecVolumesOutputReference;
}
export interface DataGoogleCloudRunServiceTemplateSpec {
}
export declare function dataGoogleCloudRunServiceTemplateSpecToTerraform(struct?: DataGoogleCloudRunServiceTemplateSpec): any;
export declare function dataGoogleCloudRunServiceTemplateSpecToHclTerraform(struct?: DataGoogleCloudRunServiceTemplateSpec): any;
export declare class DataGoogleCloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplateSpec | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplateSpec | undefined);
    get containerConcurrency(): number;
    private _containers;
    get containers(): DataGoogleCloudRunServiceTemplateSpecContainersList;
    get serviceAccountName(): string;
    get servingState(): string;
    get timeoutSeconds(): number;
    private _volumes;
    get volumes(): DataGoogleCloudRunServiceTemplateSpecVolumesList;
}
export declare class DataGoogleCloudRunServiceTemplateSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateSpecOutputReference;
}
export interface DataGoogleCloudRunServiceTemplate {
}
export declare function dataGoogleCloudRunServiceTemplateToTerraform(struct?: DataGoogleCloudRunServiceTemplate): any;
export declare function dataGoogleCloudRunServiceTemplateToHclTerraform(struct?: DataGoogleCloudRunServiceTemplate): any;
export declare class DataGoogleCloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTemplate | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTemplate | undefined);
    private _metadata;
    get metadata(): DataGoogleCloudRunServiceTemplateMetadataList;
    private _spec;
    get spec(): DataGoogleCloudRunServiceTemplateSpecList;
}
export declare class DataGoogleCloudRunServiceTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTemplateOutputReference;
}
export interface DataGoogleCloudRunServiceTraffic {
}
export declare function dataGoogleCloudRunServiceTrafficToTerraform(struct?: DataGoogleCloudRunServiceTraffic): any;
export declare function dataGoogleCloudRunServiceTrafficToHclTerraform(struct?: DataGoogleCloudRunServiceTraffic): any;
export declare class DataGoogleCloudRunServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunServiceTraffic | undefined;
    set internalValue(value: DataGoogleCloudRunServiceTraffic | undefined);
    get latestRevision(): cdktf.IResolvable;
    get percent(): number;
    get revisionName(): string;
    get tag(): string;
    get url(): string;
}
export declare class DataGoogleCloudRunServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunServiceTrafficOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service google_cloud_run_service}
*/
export declare class DataGoogleCloudRunService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_run_service";
    /**
    * Generates CDKTF code for importing a DataGoogleCloudRunService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleCloudRunService to import
    * @param importFromId The id of the existing DataGoogleCloudRunService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleCloudRunService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_service google_cloud_run_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudRunServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunServiceConfig);
    get autogenerateRevisionName(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metadata;
    get metadata(): DataGoogleCloudRunServiceMetadataList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status;
    get status(): DataGoogleCloudRunServiceStatusList;
    private _template;
    get template(): DataGoogleCloudRunServiceTemplateList;
    private _traffic;
    get traffic(): DataGoogleCloudRunServiceTrafficList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
