/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudRunV2JobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job#id DataGoogleCloudRunV2Job#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run job
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job#location DataGoogleCloudRunV2Job#location}
    */
    readonly location?: string;
    /**
    * Name of the Job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job#name DataGoogleCloudRunV2Job#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job#project DataGoogleCloudRunV2Job#project}
    */
    readonly project?: string;
}
export interface DataGoogleCloudRunV2JobBinaryAuthorization {
}
export declare function dataGoogleCloudRunV2JobBinaryAuthorizationToTerraform(struct?: DataGoogleCloudRunV2JobBinaryAuthorization): any;
export declare function dataGoogleCloudRunV2JobBinaryAuthorizationToHclTerraform(struct?: DataGoogleCloudRunV2JobBinaryAuthorization): any;
export declare class DataGoogleCloudRunV2JobBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobBinaryAuthorization | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobBinaryAuthorization | undefined);
    get breakglassJustification(): string;
    get useDefault(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunV2JobBinaryAuthorizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobBinaryAuthorizationOutputReference;
}
export interface DataGoogleCloudRunV2JobConditions {
}
export declare function dataGoogleCloudRunV2JobConditionsToTerraform(struct?: DataGoogleCloudRunV2JobConditions): any;
export declare function dataGoogleCloudRunV2JobConditionsToHclTerraform(struct?: DataGoogleCloudRunV2JobConditions): any;
export declare class DataGoogleCloudRunV2JobConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobConditions | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobConditions | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunV2JobConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobConditionsOutputReference;
}
export interface DataGoogleCloudRunV2JobLatestCreatedExecution {
}
export declare function dataGoogleCloudRunV2JobLatestCreatedExecutionToTerraform(struct?: DataGoogleCloudRunV2JobLatestCreatedExecution): any;
export declare function dataGoogleCloudRunV2JobLatestCreatedExecutionToHclTerraform(struct?: DataGoogleCloudRunV2JobLatestCreatedExecution): any;
export declare class DataGoogleCloudRunV2JobLatestCreatedExecutionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobLatestCreatedExecution | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobLatestCreatedExecution | undefined);
    get completionTime(): string;
    get createTime(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunV2JobLatestCreatedExecutionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobLatestCreatedExecutionOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRef | undefined);
    get secret(): string;
    get version(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSource | undefined);
    private _secretKeyRef;
    get secretKeyRef(): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceSecretKeyRefList;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainersEnv {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersEnvToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersEnv): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersEnvToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersEnv): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainersEnv | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainersEnv | undefined);
    get name(): string;
    get value(): string;
    private _valueSource;
    get valueSource(): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvValueSourceList;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainersPorts {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersPortsToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersPorts): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersPortsToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersPorts): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainersPorts | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainersPorts | undefined);
    get containerPort(): number;
    get name(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersPortsOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainersResources {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersResourcesToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersResources): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersResourcesToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersResources): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainersResources | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainersResources | undefined);
    private _limits;
    get limits(): cdktf.StringMap;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersResourcesOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMounts | undefined);
    get mountPath(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateContainers {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainers): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateContainersToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateContainers): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateContainers | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateContainers | undefined);
    get args(): string[];
    get command(): string[];
    private _env;
    get env(): DataGoogleCloudRunV2JobTemplateTemplateContainersEnvList;
    get image(): string;
    get name(): string;
    private _ports;
    get ports(): DataGoogleCloudRunV2JobTemplateTemplateContainersPortsList;
    private _resources;
    get resources(): DataGoogleCloudRunV2JobTemplateTemplateContainersResourcesList;
    private _volumeMounts;
    get volumeMounts(): DataGoogleCloudRunV2JobTemplateTemplateContainersVolumeMountsList;
    get workingDir(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateContainersOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstance | undefined);
    get instances(): string[];
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDir | undefined);
    get medium(): string;
    get sizeLimit(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItems {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItems): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItems): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItems | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItems | undefined);
    get mode(): number;
    get path(): string;
    get version(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVolumesSecret {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesSecretToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesSecret): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesSecretToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumesSecret): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVolumesSecret | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVolumesSecret | undefined);
    get defaultMode(): number;
    private _items;
    get items(): DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretItemsList;
    get secret(): string;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVolumes {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumes): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVolumesToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVolumes): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVolumes | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVolumes | undefined);
    private _cloudSqlInstance;
    get cloudSqlInstance(): DataGoogleCloudRunV2JobTemplateTemplateVolumesCloudSqlInstanceList;
    private _emptyDir;
    get emptyDir(): DataGoogleCloudRunV2JobTemplateTemplateVolumesEmptyDirList;
    get name(): string;
    private _secret;
    get secret(): DataGoogleCloudRunV2JobTemplateTemplateVolumesSecretList;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVolumesOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfaces | undefined);
    get network(): string;
    get subnetwork(): string;
    get tags(): string[];
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplateVpcAccess {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateVpcAccessToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVpcAccess): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateVpcAccessToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplateVpcAccess): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplateVpcAccess | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplateVpcAccess | undefined);
    get connector(): string;
    get egress(): string;
    private _networkInterfaces;
    get networkInterfaces(): DataGoogleCloudRunV2JobTemplateTemplateVpcAccessNetworkInterfacesList;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateVpcAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateVpcAccessOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplateTemplate {
}
export declare function dataGoogleCloudRunV2JobTemplateTemplateToTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplate): any;
export declare function dataGoogleCloudRunV2JobTemplateTemplateToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplateTemplate): any;
export declare class DataGoogleCloudRunV2JobTemplateTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplateTemplate | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplateTemplate | undefined);
    private _containers;
    get containers(): DataGoogleCloudRunV2JobTemplateTemplateContainersList;
    get encryptionKey(): string;
    get executionEnvironment(): string;
    get maxRetries(): number;
    get serviceAccount(): string;
    get timeout(): string;
    private _volumes;
    get volumes(): DataGoogleCloudRunV2JobTemplateTemplateVolumesList;
    private _vpcAccess;
    get vpcAccess(): DataGoogleCloudRunV2JobTemplateTemplateVpcAccessList;
}
export declare class DataGoogleCloudRunV2JobTemplateTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateTemplateOutputReference;
}
export interface DataGoogleCloudRunV2JobTemplate {
}
export declare function dataGoogleCloudRunV2JobTemplateToTerraform(struct?: DataGoogleCloudRunV2JobTemplate): any;
export declare function dataGoogleCloudRunV2JobTemplateToHclTerraform(struct?: DataGoogleCloudRunV2JobTemplate): any;
export declare class DataGoogleCloudRunV2JobTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTemplate | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTemplate | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    private _labels;
    get labels(): cdktf.StringMap;
    get parallelism(): number;
    get taskCount(): number;
    private _template;
    get template(): DataGoogleCloudRunV2JobTemplateTemplateList;
}
export declare class DataGoogleCloudRunV2JobTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTemplateOutputReference;
}
export interface DataGoogleCloudRunV2JobTerminalCondition {
}
export declare function dataGoogleCloudRunV2JobTerminalConditionToTerraform(struct?: DataGoogleCloudRunV2JobTerminalCondition): any;
export declare function dataGoogleCloudRunV2JobTerminalConditionToHclTerraform(struct?: DataGoogleCloudRunV2JobTerminalCondition): any;
export declare class DataGoogleCloudRunV2JobTerminalConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2JobTerminalCondition | undefined;
    set internalValue(value: DataGoogleCloudRunV2JobTerminalCondition | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunV2JobTerminalConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2JobTerminalConditionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job google_cloud_run_v2_job}
*/
export declare class DataGoogleCloudRunV2Job extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_run_v2_job";
    /**
    * Generates CDKTF code for importing a DataGoogleCloudRunV2Job resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleCloudRunV2Job to import
    * @param importFromId The id of the existing DataGoogleCloudRunV2Job that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleCloudRunV2Job to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_job google_cloud_run_v2_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudRunV2JobConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunV2JobConfig);
    private _annotations;
    get annotations(): cdktf.StringMap;
    private _binaryAuthorization;
    get binaryAuthorization(): DataGoogleCloudRunV2JobBinaryAuthorizationList;
    get client(): string;
    get clientVersion(): string;
    private _conditions;
    get conditions(): DataGoogleCloudRunV2JobConditionsList;
    get createTime(): string;
    get creator(): string;
    get deleteTime(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    get executionCount(): number;
    get expireTime(): string;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    get lastModifier(): string;
    private _latestCreatedExecution;
    get latestCreatedExecution(): DataGoogleCloudRunV2JobLatestCreatedExecutionList;
    get launchStage(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get observedGeneration(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _template;
    get template(): DataGoogleCloudRunV2JobTemplateList;
    private _terminalCondition;
    get terminalCondition(): DataGoogleCloudRunV2JobTerminalConditionList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
