/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleCloudRunV2ServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service#id DataGoogleCloudRunV2Service#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service#location DataGoogleCloudRunV2Service#location}
    */
    readonly location?: string;
    /**
    * Name of the Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service#name DataGoogleCloudRunV2Service#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service#project DataGoogleCloudRunV2Service#project}
    */
    readonly project?: string;
}
export interface DataGoogleCloudRunV2ServiceBinaryAuthorization {
}
export declare function dataGoogleCloudRunV2ServiceBinaryAuthorizationToTerraform(struct?: DataGoogleCloudRunV2ServiceBinaryAuthorization): any;
export declare function dataGoogleCloudRunV2ServiceBinaryAuthorizationToHclTerraform(struct?: DataGoogleCloudRunV2ServiceBinaryAuthorization): any;
export declare class DataGoogleCloudRunV2ServiceBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceBinaryAuthorization | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceBinaryAuthorization | undefined);
    get breakglassJustification(): string;
    get useDefault(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunV2ServiceBinaryAuthorizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceBinaryAuthorizationOutputReference;
}
export interface DataGoogleCloudRunV2ServiceConditions {
}
export declare function dataGoogleCloudRunV2ServiceConditionsToTerraform(struct?: DataGoogleCloudRunV2ServiceConditions): any;
export declare function dataGoogleCloudRunV2ServiceConditionsToHclTerraform(struct?: DataGoogleCloudRunV2ServiceConditions): any;
export declare class DataGoogleCloudRunV2ServiceConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceConditions | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceConditions | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunV2ServiceConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceConditionsOutputReference;
}
export interface DataGoogleCloudRunV2ServiceScaling {
}
export declare function dataGoogleCloudRunV2ServiceScalingToTerraform(struct?: DataGoogleCloudRunV2ServiceScaling): any;
export declare function dataGoogleCloudRunV2ServiceScalingToHclTerraform(struct?: DataGoogleCloudRunV2ServiceScaling): any;
export declare class DataGoogleCloudRunV2ServiceScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceScaling | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceScaling | undefined);
    get minInstanceCount(): number;
}
export declare class DataGoogleCloudRunV2ServiceScalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceScalingOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRef | undefined);
    get secret(): string;
    get version(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSource {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSource): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSource): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSource | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSource | undefined);
    private _secretKeyRef;
    get secretKeyRef(): DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceSecretKeyRefList;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersEnv {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersEnvToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersEnv): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersEnvToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersEnv): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersEnv | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersEnv | undefined);
    get name(): string;
    get value(): string;
    private _valueSource;
    get valueSource(): DataGoogleCloudRunV2ServiceTemplateContainersEnvValueSourceList;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersEnvOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpc | undefined);
    get port(): number;
    get service(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeaders | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGet | undefined);
    private _httpHeaders;
    get httpHeaders(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetHttpHeadersList;
    get path(): string;
    get port(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocket | undefined);
    get port(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbe {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbe): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbe): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbe | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbe | undefined);
    get failureThreshold(): number;
    private _grpc;
    get grpc(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeGrpcList;
    private _httpGet;
    get httpGet(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeHttpGetList;
    get initialDelaySeconds(): number;
    get periodSeconds(): number;
    private _tcpSocket;
    get tcpSocket(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeTcpSocketList;
    get timeoutSeconds(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersPorts {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersPortsToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersPorts): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersPortsToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersPorts): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersPorts | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersPorts | undefined);
    get containerPort(): number;
    get name(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersPortsOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersResources {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersResourcesToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersResources): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersResourcesToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersResources): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersResources | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersResources | undefined);
    get cpuIdle(): cdktf.IResolvable;
    private _limits;
    get limits(): cdktf.StringMap;
    get startupCpuBoost(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersResourcesOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpc | undefined);
    get port(): number;
    get service(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeaders | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGet | undefined);
    private _httpHeaders;
    get httpHeaders(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetHttpHeadersList;
    get path(): string;
    get port(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocket | undefined);
    get port(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersStartupProbe {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbe): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersStartupProbeToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbe): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbe | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersStartupProbe | undefined);
    get failureThreshold(): number;
    private _grpc;
    get grpc(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeGrpcList;
    private _httpGet;
    get httpGet(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeHttpGetList;
    get initialDelaySeconds(): number;
    get periodSeconds(): number;
    private _tcpSocket;
    get tcpSocket(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeTcpSocketList;
    get timeoutSeconds(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainersVolumeMounts {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersVolumeMountsToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersVolumeMounts): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersVolumeMountsToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainersVolumeMounts): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainersVolumeMounts | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainersVolumeMounts | undefined);
    get mountPath(): string;
    get name(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersVolumeMountsOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateContainers {
}
export declare function dataGoogleCloudRunV2ServiceTemplateContainersToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainers): any;
export declare function dataGoogleCloudRunV2ServiceTemplateContainersToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateContainers): any;
export declare class DataGoogleCloudRunV2ServiceTemplateContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateContainers | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateContainers | undefined);
    get args(): string[];
    get command(): string[];
    get dependsOn(): string[];
    private _env;
    get env(): DataGoogleCloudRunV2ServiceTemplateContainersEnvList;
    get image(): string;
    private _livenessProbe;
    get livenessProbe(): DataGoogleCloudRunV2ServiceTemplateContainersLivenessProbeList;
    get name(): string;
    private _ports;
    get ports(): DataGoogleCloudRunV2ServiceTemplateContainersPortsList;
    private _resources;
    get resources(): DataGoogleCloudRunV2ServiceTemplateContainersResourcesList;
    private _startupProbe;
    get startupProbe(): DataGoogleCloudRunV2ServiceTemplateContainersStartupProbeList;
    private _volumeMounts;
    get volumeMounts(): DataGoogleCloudRunV2ServiceTemplateContainersVolumeMountsList;
    get workingDir(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateContainersOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateScaling {
}
export declare function dataGoogleCloudRunV2ServiceTemplateScalingToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateScaling): any;
export declare function dataGoogleCloudRunV2ServiceTemplateScalingToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateScaling): any;
export declare class DataGoogleCloudRunV2ServiceTemplateScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateScaling | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateScaling | undefined);
    get maxInstanceCount(): number;
    get minInstanceCount(): number;
}
export declare class DataGoogleCloudRunV2ServiceTemplateScalingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateScalingOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstance | undefined);
    get instances(): string[];
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDir {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesEmptyDirToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDir): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesEmptyDirToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDir): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDirOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDir | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDir | undefined);
    get medium(): string;
    get sizeLimit(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDirList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDirOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumesGcs {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesGcsToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesGcs): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesGcsToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesGcs): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesGcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumesGcs | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumesGcs | undefined);
    get bucket(): string;
    get readOnly(): cdktf.IResolvable;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesGcsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesGcsOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumesNfs {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesNfsToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesNfs): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesNfsToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesNfs): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesNfsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumesNfs | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumesNfs | undefined);
    get path(): string;
    get readOnly(): cdktf.IResolvable;
    get server(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesNfsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesNfsOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumesSecretItems {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesSecretItemsToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesSecretItems): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesSecretItemsToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesSecretItems): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumesSecretItems | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumesSecretItems | undefined);
    get mode(): number;
    get path(): string;
    get version(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesSecretItemsOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumesSecret {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesSecretToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesSecret): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesSecretToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumesSecret): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumesSecret | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumesSecret | undefined);
    get defaultMode(): number;
    private _items;
    get items(): DataGoogleCloudRunV2ServiceTemplateVolumesSecretItemsList;
    get secret(): string;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesSecretOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVolumes {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumes): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVolumesToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVolumes): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVolumes | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVolumes | undefined);
    private _cloudSqlInstance;
    get cloudSqlInstance(): DataGoogleCloudRunV2ServiceTemplateVolumesCloudSqlInstanceList;
    private _emptyDir;
    get emptyDir(): DataGoogleCloudRunV2ServiceTemplateVolumesEmptyDirList;
    private _gcs;
    get gcs(): DataGoogleCloudRunV2ServiceTemplateVolumesGcsList;
    get name(): string;
    private _nfs;
    get nfs(): DataGoogleCloudRunV2ServiceTemplateVolumesNfsList;
    private _secret;
    get secret(): DataGoogleCloudRunV2ServiceTemplateVolumesSecretList;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVolumesOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfaces | undefined);
    get network(): string;
    get subnetwork(): string;
    get tags(): string[];
}
export declare class DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplateVpcAccess {
}
export declare function dataGoogleCloudRunV2ServiceTemplateVpcAccessToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVpcAccess): any;
export declare function dataGoogleCloudRunV2ServiceTemplateVpcAccessToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplateVpcAccess): any;
export declare class DataGoogleCloudRunV2ServiceTemplateVpcAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplateVpcAccess | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplateVpcAccess | undefined);
    get connector(): string;
    get egress(): string;
    private _networkInterfaces;
    get networkInterfaces(): DataGoogleCloudRunV2ServiceTemplateVpcAccessNetworkInterfacesList;
}
export declare class DataGoogleCloudRunV2ServiceTemplateVpcAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateVpcAccessOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTemplate {
}
export declare function dataGoogleCloudRunV2ServiceTemplateToTerraform(struct?: DataGoogleCloudRunV2ServiceTemplate): any;
export declare function dataGoogleCloudRunV2ServiceTemplateToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTemplate): any;
export declare class DataGoogleCloudRunV2ServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTemplate | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTemplate | undefined);
    private _annotations;
    get annotations(): cdktf.StringMap;
    private _containers;
    get containers(): DataGoogleCloudRunV2ServiceTemplateContainersList;
    get encryptionKey(): string;
    get executionEnvironment(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get maxInstanceRequestConcurrency(): number;
    get revision(): string;
    private _scaling;
    get scaling(): DataGoogleCloudRunV2ServiceTemplateScalingList;
    get serviceAccount(): string;
    get sessionAffinity(): cdktf.IResolvable;
    get timeout(): string;
    private _volumes;
    get volumes(): DataGoogleCloudRunV2ServiceTemplateVolumesList;
    private _vpcAccess;
    get vpcAccess(): DataGoogleCloudRunV2ServiceTemplateVpcAccessList;
}
export declare class DataGoogleCloudRunV2ServiceTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTemplateOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTerminalCondition {
}
export declare function dataGoogleCloudRunV2ServiceTerminalConditionToTerraform(struct?: DataGoogleCloudRunV2ServiceTerminalCondition): any;
export declare function dataGoogleCloudRunV2ServiceTerminalConditionToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTerminalCondition): any;
export declare class DataGoogleCloudRunV2ServiceTerminalConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTerminalCondition | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTerminalCondition | undefined);
    get executionReason(): string;
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get revisionReason(): string;
    get severity(): string;
    get state(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunV2ServiceTerminalConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTerminalConditionOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTraffic {
}
export declare function dataGoogleCloudRunV2ServiceTrafficToTerraform(struct?: DataGoogleCloudRunV2ServiceTraffic): any;
export declare function dataGoogleCloudRunV2ServiceTrafficToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTraffic): any;
export declare class DataGoogleCloudRunV2ServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTraffic | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTraffic | undefined);
    get percent(): number;
    get revision(): string;
    get tag(): string;
    get type(): string;
}
export declare class DataGoogleCloudRunV2ServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTrafficOutputReference;
}
export interface DataGoogleCloudRunV2ServiceTrafficStatuses {
}
export declare function dataGoogleCloudRunV2ServiceTrafficStatusesToTerraform(struct?: DataGoogleCloudRunV2ServiceTrafficStatuses): any;
export declare function dataGoogleCloudRunV2ServiceTrafficStatusesToHclTerraform(struct?: DataGoogleCloudRunV2ServiceTrafficStatuses): any;
export declare class DataGoogleCloudRunV2ServiceTrafficStatusesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleCloudRunV2ServiceTrafficStatuses | undefined;
    set internalValue(value: DataGoogleCloudRunV2ServiceTrafficStatuses | undefined);
    get percent(): number;
    get revision(): string;
    get tag(): string;
    get type(): string;
    get uri(): string;
}
export declare class DataGoogleCloudRunV2ServiceTrafficStatusesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleCloudRunV2ServiceTrafficStatusesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service google_cloud_run_v2_service}
*/
export declare class DataGoogleCloudRunV2Service extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_cloud_run_v2_service";
    /**
    * Generates CDKTF code for importing a DataGoogleCloudRunV2Service resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleCloudRunV2Service to import
    * @param importFromId The id of the existing DataGoogleCloudRunV2Service that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleCloudRunV2Service to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_cloud_run_v2_service google_cloud_run_v2_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleCloudRunV2ServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleCloudRunV2ServiceConfig);
    private _annotations;
    get annotations(): cdktf.StringMap;
    private _binaryAuthorization;
    get binaryAuthorization(): DataGoogleCloudRunV2ServiceBinaryAuthorizationList;
    get client(): string;
    get clientVersion(): string;
    private _conditions;
    get conditions(): DataGoogleCloudRunV2ServiceConditionsList;
    get createTime(): string;
    get creator(): string;
    get customAudiences(): string[];
    get deleteTime(): string;
    get description(): string;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    get expireTime(): string;
    get generation(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ingress(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get lastModifier(): string;
    get latestCreatedRevision(): string;
    get latestReadyRevision(): string;
    get launchStage(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get observedGeneration(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _scaling;
    get scaling(): DataGoogleCloudRunV2ServiceScalingList;
    private _template;
    get template(): DataGoogleCloudRunV2ServiceTemplateList;
    private _terminalCondition;
    get terminalCondition(): DataGoogleCloudRunV2ServiceTerminalConditionList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _traffic;
    get traffic(): DataGoogleCloudRunV2ServiceTrafficList;
    private _trafficStatuses;
    get trafficStatuses(): DataGoogleCloudRunV2ServiceTrafficStatusesList;
    get uid(): string;
    get updateTime(): string;
    get uri(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
