/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComposerEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment#id DataGoogleComposerEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment#name DataGoogleComposerEnvironment#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment#project DataGoogleComposerEnvironment#project}
    */
    readonly project?: string;
    /**
    * The location or Compute Engine region for the environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment#region DataGoogleComposerEnvironment#region}
    */
    readonly region?: string;
}
export interface DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig {
}
export declare function dataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig): any;
export declare function dataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig): any;
export declare class DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfig | undefined);
    get storageMode(): string;
}
export declare class DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigDataRetentionConfig {
}
export declare function dataGoogleComposerEnvironmentConfigDataRetentionConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigDataRetentionConfig): any;
export declare function dataGoogleComposerEnvironmentConfigDataRetentionConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigDataRetentionConfig): any;
export declare class DataGoogleComposerEnvironmentConfigDataRetentionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigDataRetentionConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigDataRetentionConfig | undefined);
    private _taskLogsRetentionConfig;
    get taskLogsRetentionConfig(): DataGoogleComposerEnvironmentConfigDataRetentionConfigTaskLogsRetentionConfigList;
}
export declare class DataGoogleComposerEnvironmentConfigDataRetentionConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigDataRetentionConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigDatabaseConfig {
}
export declare function dataGoogleComposerEnvironmentConfigDatabaseConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigDatabaseConfig): any;
export declare function dataGoogleComposerEnvironmentConfigDatabaseConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigDatabaseConfig): any;
export declare class DataGoogleComposerEnvironmentConfigDatabaseConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigDatabaseConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigDatabaseConfig | undefined);
    get machineType(): string;
    get zone(): string;
}
export declare class DataGoogleComposerEnvironmentConfigDatabaseConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigDatabaseConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigEncryptionConfig {
}
export declare function dataGoogleComposerEnvironmentConfigEncryptionConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigEncryptionConfig): any;
export declare function dataGoogleComposerEnvironmentConfigEncryptionConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigEncryptionConfig): any;
export declare class DataGoogleComposerEnvironmentConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigEncryptionConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigEncryptionConfig | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleComposerEnvironmentConfigEncryptionConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigEncryptionConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigMaintenanceWindow {
}
export declare function dataGoogleComposerEnvironmentConfigMaintenanceWindowToTerraform(struct?: DataGoogleComposerEnvironmentConfigMaintenanceWindow): any;
export declare function dataGoogleComposerEnvironmentConfigMaintenanceWindowToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigMaintenanceWindow): any;
export declare class DataGoogleComposerEnvironmentConfigMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigMaintenanceWindow | undefined);
    get endTime(): string;
    get recurrence(): string;
    get startTime(): string;
}
export declare class DataGoogleComposerEnvironmentConfigMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigMaintenanceWindowOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks {
}
export declare function dataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks): any;
export declare function dataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks): any;
export declare class DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocks | undefined);
    get cidrBlock(): string;
    get displayName(): string;
}
export declare class DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfig {
}
export declare function dataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfig): any;
export declare function dataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfig): any;
export declare class DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfig | undefined);
    private _cidrBlocks;
    get cidrBlocks(): DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigCidrBlocksList;
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy {
}
export declare function dataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyToTerraform(struct?: DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy): any;
export declare function dataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy): any;
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicy | undefined);
    get clusterIpv4CidrBlock(): string;
    get clusterSecondaryRangeName(): string;
    get servicesIpv4CidrBlock(): string;
    get servicesSecondaryRangeName(): string;
    get useIpAliases(): cdktf.IResolvable;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigNodeConfig {
}
export declare function dataGoogleComposerEnvironmentConfigNodeConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigNodeConfig): any;
export declare function dataGoogleComposerEnvironmentConfigNodeConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigNodeConfig): any;
export declare class DataGoogleComposerEnvironmentConfigNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigNodeConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigNodeConfig | undefined);
    get composerInternalIpv4CidrBlock(): string;
    get composerNetworkAttachment(): string;
    get diskSizeGb(): number;
    get enableIpMasqAgent(): cdktf.IResolvable;
    private _ipAllocationPolicy;
    get ipAllocationPolicy(): DataGoogleComposerEnvironmentConfigNodeConfigIpAllocationPolicyList;
    get machineType(): string;
    get maxPodsPerNode(): number;
    get network(): string;
    get oauthScopes(): string[];
    get serviceAccount(): string;
    get subnetwork(): string;
    get tags(): string[];
    get zone(): string;
}
export declare class DataGoogleComposerEnvironmentConfigNodeConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigNodeConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig {
}
export declare function dataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig): any;
export declare function dataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig): any;
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfig | undefined);
    get cloudComposerConnectionSubnetwork(): string;
    get cloudComposerNetworkIpv4CidrBlock(): string;
    get cloudSqlIpv4CidrBlock(): string;
    get connectionType(): string;
    get enablePrivateEndpoint(): cdktf.IResolvable;
    get enablePrivatelyUsedPublicIps(): cdktf.IResolvable;
    get masterIpv4CidrBlock(): string;
    get webServerIpv4CidrBlock(): string;
}
export declare class DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig {
}
export declare function dataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig): any;
export declare function dataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig): any;
export declare class DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfig | undefined);
    get enabled(): cdktf.IResolvable;
    get snapshotCreationSchedule(): string;
    get snapshotLocation(): string;
    get timeZone(): string;
}
export declare class DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigRecoveryConfig {
}
export declare function dataGoogleComposerEnvironmentConfigRecoveryConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigRecoveryConfig): any;
export declare function dataGoogleComposerEnvironmentConfigRecoveryConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigRecoveryConfig): any;
export declare class DataGoogleComposerEnvironmentConfigRecoveryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigRecoveryConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigRecoveryConfig | undefined);
    private _scheduledSnapshotsConfig;
    get scheduledSnapshotsConfig(): DataGoogleComposerEnvironmentConfigRecoveryConfigScheduledSnapshotsConfigList;
}
export declare class DataGoogleComposerEnvironmentConfigRecoveryConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigRecoveryConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegration {
}
export declare function dataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationToTerraform(struct?: DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegration): any;
export declare function dataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegration): any;
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegration | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegration | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigSoftwareConfig {
}
export declare function dataGoogleComposerEnvironmentConfigSoftwareConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigSoftwareConfig): any;
export declare function dataGoogleComposerEnvironmentConfigSoftwareConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigSoftwareConfig): any;
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigSoftwareConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigSoftwareConfig | undefined);
    private _airflowConfigOverrides;
    get airflowConfigOverrides(): cdktf.StringMap;
    private _cloudDataLineageIntegration;
    get cloudDataLineageIntegration(): DataGoogleComposerEnvironmentConfigSoftwareConfigCloudDataLineageIntegrationList;
    private _envVariables;
    get envVariables(): cdktf.StringMap;
    get imageVersion(): string;
    private _pypiPackages;
    get pypiPackages(): cdktf.StringMap;
    get pythonVersion(): string;
    get schedulerCount(): number;
    get webServerPluginsMode(): string;
}
export declare class DataGoogleComposerEnvironmentConfigSoftwareConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigSoftwareConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWebServerConfig {
}
export declare function dataGoogleComposerEnvironmentConfigWebServerConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerConfig): any;
export declare function dataGoogleComposerEnvironmentConfigWebServerConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerConfig): any;
export declare class DataGoogleComposerEnvironmentConfigWebServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWebServerConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWebServerConfig | undefined);
    get machineType(): string;
}
export declare class DataGoogleComposerEnvironmentConfigWebServerConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWebServerConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange {
}
export declare function dataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeToTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange): any;
export declare function dataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange): any;
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRange | undefined);
    get description(): string;
    get value(): string;
}
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl {
}
export declare function dataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlToTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl): any;
export declare function dataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl): any;
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControl | undefined);
    private _allowedIpRange;
    get allowedIpRange(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlAllowedIpRangeList;
}
export declare class DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessor {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessorToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessor): any;
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessorToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessor): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessor | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessor | undefined);
    get cpu(): number;
    get memoryGb(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessorOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler): any;
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigScheduler | undefined);
    get count(): number;
    get cpu(): number;
    get memoryGb(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggerer {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigTriggererToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggerer): any;
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigTriggererToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggerer): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggererOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggerer | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggerer | undefined);
    get count(): number;
    get cpu(): number;
    get memoryGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggererList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggererOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer): any;
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServer | undefined);
    get cpu(): number;
    get memoryGb(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker): any;
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfigWorker | undefined);
    get cpu(): number;
    get maxCount(): number;
    get memoryGb(): number;
    get minCount(): number;
    get storageGb(): number;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigWorkloadsConfig {
}
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigToTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfig): any;
export declare function dataGoogleComposerEnvironmentConfigWorkloadsConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigWorkloadsConfig): any;
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigWorkloadsConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigWorkloadsConfig | undefined);
    private _dagProcessor;
    get dagProcessor(): DataGoogleComposerEnvironmentConfigWorkloadsConfigDagProcessorList;
    private _scheduler;
    get scheduler(): DataGoogleComposerEnvironmentConfigWorkloadsConfigSchedulerList;
    private _triggerer;
    get triggerer(): DataGoogleComposerEnvironmentConfigWorkloadsConfigTriggererList;
    private _webServer;
    get webServer(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWebServerList;
    private _worker;
    get worker(): DataGoogleComposerEnvironmentConfigWorkloadsConfigWorkerList;
}
export declare class DataGoogleComposerEnvironmentConfigWorkloadsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigWorkloadsConfigOutputReference;
}
export interface DataGoogleComposerEnvironmentConfigA {
}
export declare function dataGoogleComposerEnvironmentConfigAToTerraform(struct?: DataGoogleComposerEnvironmentConfigA): any;
export declare function dataGoogleComposerEnvironmentConfigAToHclTerraform(struct?: DataGoogleComposerEnvironmentConfigA): any;
export declare class DataGoogleComposerEnvironmentConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentConfigA | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentConfigA | undefined);
    get airflowUri(): string;
    get dagGcsPrefix(): string;
    private _dataRetentionConfig;
    get dataRetentionConfig(): DataGoogleComposerEnvironmentConfigDataRetentionConfigList;
    private _databaseConfig;
    get databaseConfig(): DataGoogleComposerEnvironmentConfigDatabaseConfigList;
    get enablePrivateBuildsOnly(): cdktf.IResolvable;
    get enablePrivateEnvironment(): cdktf.IResolvable;
    private _encryptionConfig;
    get encryptionConfig(): DataGoogleComposerEnvironmentConfigEncryptionConfigList;
    get environmentSize(): string;
    get gkeCluster(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataGoogleComposerEnvironmentConfigMaintenanceWindowList;
    private _masterAuthorizedNetworksConfig;
    get masterAuthorizedNetworksConfig(): DataGoogleComposerEnvironmentConfigMasterAuthorizedNetworksConfigList;
    private _nodeConfig;
    get nodeConfig(): DataGoogleComposerEnvironmentConfigNodeConfigList;
    get nodeCount(): number;
    private _privateEnvironmentConfig;
    get privateEnvironmentConfig(): DataGoogleComposerEnvironmentConfigPrivateEnvironmentConfigList;
    private _recoveryConfig;
    get recoveryConfig(): DataGoogleComposerEnvironmentConfigRecoveryConfigList;
    get resilienceMode(): string;
    private _softwareConfig;
    get softwareConfig(): DataGoogleComposerEnvironmentConfigSoftwareConfigList;
    private _webServerConfig;
    get webServerConfig(): DataGoogleComposerEnvironmentConfigWebServerConfigList;
    private _webServerNetworkAccessControl;
    get webServerNetworkAccessControl(): DataGoogleComposerEnvironmentConfigWebServerNetworkAccessControlList;
    private _workloadsConfig;
    get workloadsConfig(): DataGoogleComposerEnvironmentConfigWorkloadsConfigList;
}
export declare class DataGoogleComposerEnvironmentConfigAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentConfigAOutputReference;
}
export interface DataGoogleComposerEnvironmentStorageConfig {
}
export declare function dataGoogleComposerEnvironmentStorageConfigToTerraform(struct?: DataGoogleComposerEnvironmentStorageConfig): any;
export declare function dataGoogleComposerEnvironmentStorageConfigToHclTerraform(struct?: DataGoogleComposerEnvironmentStorageConfig): any;
export declare class DataGoogleComposerEnvironmentStorageConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComposerEnvironmentStorageConfig | undefined;
    set internalValue(value: DataGoogleComposerEnvironmentStorageConfig | undefined);
    get bucket(): string;
}
export declare class DataGoogleComposerEnvironmentStorageConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComposerEnvironmentStorageConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment google_composer_environment}
*/
export declare class DataGoogleComposerEnvironment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_composer_environment";
    /**
    * Generates CDKTF code for importing a DataGoogleComposerEnvironment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComposerEnvironment to import
    * @param importFromId The id of the existing DataGoogleComposerEnvironment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComposerEnvironment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_composer_environment google_composer_environment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComposerEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComposerEnvironmentConfig);
    private _config;
    get config(): DataGoogleComposerEnvironmentConfigAList;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels;
    get labels(): cdktf.StringMap;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _storageConfig;
    get storageConfig(): DataGoogleComposerEnvironmentStorageConfigList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
