/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeBackendBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_backend_bucket#id DataGoogleComputeBackendBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035.  Specifically, the name must be 1-63 characters long and
    * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
    * the first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the
    * last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_backend_bucket#name DataGoogleComputeBackendBucket#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_backend_bucket#project DataGoogleComputeBackendBucket#project}
    */
    readonly project?: string;
}
export interface DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders {
}
export declare function dataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersToTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders): any;
export declare function dataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersToHclTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders): any;
export declare class DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders | undefined;
    set internalValue(value: DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders | undefined);
    get headerName(): string;
}
export declare class DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersOutputReference;
}
export interface DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicy {
}
export declare function dataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicyToTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicy): any;
export declare function dataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicyToHclTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicy): any;
export declare class DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicy | undefined;
    set internalValue(value: DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicy | undefined);
    get includeHttpHeaders(): string[];
    get queryStringWhitelist(): string[];
}
export declare class DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicyOutputReference;
}
export interface DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy {
}
export declare function dataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicyToTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy): any;
export declare function dataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicyToHclTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy): any;
export declare class DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy | undefined;
    set internalValue(value: DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicy | undefined);
    get code(): number;
    get ttl(): number;
}
export declare class DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicyOutputReference;
}
export interface DataGoogleComputeBackendBucketCdnPolicy {
}
export declare function dataGoogleComputeBackendBucketCdnPolicyToTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicy): any;
export declare function dataGoogleComputeBackendBucketCdnPolicyToHclTerraform(struct?: DataGoogleComputeBackendBucketCdnPolicy): any;
export declare class DataGoogleComputeBackendBucketCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendBucketCdnPolicy | undefined;
    set internalValue(value: DataGoogleComputeBackendBucketCdnPolicy | undefined);
    private _bypassCacheOnRequestHeaders;
    get bypassCacheOnRequestHeaders(): DataGoogleComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersList;
    private _cacheKeyPolicy;
    get cacheKeyPolicy(): DataGoogleComputeBackendBucketCdnPolicyCacheKeyPolicyList;
    get cacheMode(): string;
    get clientTtl(): number;
    get defaultTtl(): number;
    get maxTtl(): number;
    get negativeCaching(): cdktf.IResolvable;
    private _negativeCachingPolicy;
    get negativeCachingPolicy(): DataGoogleComputeBackendBucketCdnPolicyNegativeCachingPolicyList;
    get requestCoalescing(): cdktf.IResolvable;
    get serveWhileStale(): number;
    get signedUrlCacheMaxAgeSec(): number;
}
export declare class DataGoogleComputeBackendBucketCdnPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendBucketCdnPolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_backend_bucket google_compute_backend_bucket}
*/
export declare class DataGoogleComputeBackendBucket extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_backend_bucket";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeBackendBucket resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeBackendBucket to import
    * @param importFromId The id of the existing DataGoogleComputeBackendBucket that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_backend_bucket#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeBackendBucket to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_backend_bucket google_compute_backend_bucket} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeBackendBucketConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeBackendBucketConfig);
    get bucketName(): string;
    private _cdnPolicy;
    get cdnPolicy(): DataGoogleComputeBackendBucketCdnPolicyList;
    get compressionMode(): string;
    get creationTimestamp(): string;
    get customResponseHeaders(): string[];
    get description(): string;
    get edgeSecurityPolicy(): string;
    get enableCdn(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
