/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk#id DataGoogleComputeDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk#name DataGoogleComputeDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk#project DataGoogleComputeDisk#project}
    */
    readonly project?: string;
    /**
    * A reference to the zone where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk#zone DataGoogleComputeDisk#zone}
    */
    readonly zone?: string;
}
export interface DataGoogleComputeDiskAsyncPrimaryDisk {
}
export declare function dataGoogleComputeDiskAsyncPrimaryDiskToTerraform(struct?: DataGoogleComputeDiskAsyncPrimaryDisk): any;
export declare function dataGoogleComputeDiskAsyncPrimaryDiskToHclTerraform(struct?: DataGoogleComputeDiskAsyncPrimaryDisk): any;
export declare class DataGoogleComputeDiskAsyncPrimaryDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskAsyncPrimaryDisk | undefined;
    set internalValue(value: DataGoogleComputeDiskAsyncPrimaryDisk | undefined);
    get disk(): string;
}
export declare class DataGoogleComputeDiskAsyncPrimaryDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskAsyncPrimaryDiskOutputReference;
}
export interface DataGoogleComputeDiskDiskEncryptionKey {
}
export declare function dataGoogleComputeDiskDiskEncryptionKeyToTerraform(struct?: DataGoogleComputeDiskDiskEncryptionKey): any;
export declare function dataGoogleComputeDiskDiskEncryptionKeyToHclTerraform(struct?: DataGoogleComputeDiskDiskEncryptionKey): any;
export declare class DataGoogleComputeDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskDiskEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeDiskDiskEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get rsaEncryptedKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeDiskDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskDiskEncryptionKeyOutputReference;
}
export interface DataGoogleComputeDiskGuestOsFeatures {
}
export declare function dataGoogleComputeDiskGuestOsFeaturesToTerraform(struct?: DataGoogleComputeDiskGuestOsFeatures): any;
export declare function dataGoogleComputeDiskGuestOsFeaturesToHclTerraform(struct?: DataGoogleComputeDiskGuestOsFeatures): any;
export declare class DataGoogleComputeDiskGuestOsFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskGuestOsFeatures | undefined;
    set internalValue(value: DataGoogleComputeDiskGuestOsFeatures | undefined);
    get type(): string;
}
export declare class DataGoogleComputeDiskGuestOsFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskGuestOsFeaturesOutputReference;
}
export interface DataGoogleComputeDiskSourceImageEncryptionKey {
}
export declare function dataGoogleComputeDiskSourceImageEncryptionKeyToTerraform(struct?: DataGoogleComputeDiskSourceImageEncryptionKey): any;
export declare function dataGoogleComputeDiskSourceImageEncryptionKeyToHclTerraform(struct?: DataGoogleComputeDiskSourceImageEncryptionKey): any;
export declare class DataGoogleComputeDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeDiskSourceImageEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeDiskSourceImageEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskSourceImageEncryptionKeyOutputReference;
}
export interface DataGoogleComputeDiskSourceSnapshotEncryptionKey {
}
export declare function dataGoogleComputeDiskSourceSnapshotEncryptionKeyToTerraform(struct?: DataGoogleComputeDiskSourceSnapshotEncryptionKey): any;
export declare function dataGoogleComputeDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: DataGoogleComputeDiskSourceSnapshotEncryptionKey): any;
export declare class DataGoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeDiskSourceSnapshotEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeDiskSourceSnapshotEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeDiskSourceSnapshotEncryptionKeyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk google_compute_disk}
*/
export declare class DataGoogleComputeDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_disk";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeDisk to import
    * @param importFromId The id of the existing DataGoogleComputeDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_disk google_compute_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeDiskConfig);
    private _asyncPrimaryDisk;
    get asyncPrimaryDisk(): DataGoogleComputeDiskAsyncPrimaryDiskList;
    get creationTimestamp(): string;
    get description(): string;
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataGoogleComputeDiskDiskEncryptionKeyList;
    get diskId(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get enableConfidentialCompute(): cdktf.IResolvable;
    private _guestOsFeatures;
    get guestOsFeatures(): DataGoogleComputeDiskGuestOsFeaturesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get image(): string;
    get interface(): string;
    get labelFingerprint(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    get licenses(): string[];
    get multiWriter(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get physicalBlockSizeBytes(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get provisionedIops(): number;
    get provisionedThroughput(): number;
    get resourcePolicies(): string[];
    get selfLink(): string;
    get size(): number;
    get snapshot(): string;
    get sourceDisk(): string;
    get sourceDiskId(): string;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): DataGoogleComputeDiskSourceImageEncryptionKeyList;
    get sourceImageId(): string;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): DataGoogleComputeDiskSourceSnapshotEncryptionKeyList;
    get sourceSnapshotId(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get type(): string;
    get users(): string[];
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
