/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeForwardingRulesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_forwarding_rules#id DataGoogleComputeForwardingRules#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_forwarding_rules#project DataGoogleComputeForwardingRules#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_forwarding_rules#region DataGoogleComputeForwardingRules#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrations {
}
export declare function dataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrationsToTerraform(struct?: DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrations): any;
export declare function dataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrationsToHclTerraform(struct?: DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrations): any;
export declare class DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrations | undefined;
    set internalValue(value: DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrations | undefined);
    get namespace(): string;
    get service(): string;
}
export declare class DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrationsOutputReference;
}
export interface DataGoogleComputeForwardingRulesRules {
}
export declare function dataGoogleComputeForwardingRulesRulesToTerraform(struct?: DataGoogleComputeForwardingRulesRules): any;
export declare function dataGoogleComputeForwardingRulesRulesToHclTerraform(struct?: DataGoogleComputeForwardingRulesRules): any;
export declare class DataGoogleComputeForwardingRulesRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeForwardingRulesRules | undefined;
    set internalValue(value: DataGoogleComputeForwardingRulesRules | undefined);
    get allPorts(): cdktf.IResolvable;
    get allowGlobalAccess(): cdktf.IResolvable;
    get allowPscGlobalAccess(): cdktf.IResolvable;
    get backendService(): string;
    get baseForwardingRule(): string;
    get creationTimestamp(): string;
    get description(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get ipAddress(): string;
    get ipProtocol(): string;
    get ipVersion(): string;
    get isMirroringCollector(): cdktf.IResolvable;
    get labelFingerprint(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get loadBalancingScheme(): string;
    get name(): string;
    get network(): string;
    get networkTier(): string;
    get noAutomateDnsZone(): cdktf.IResolvable;
    get portRange(): string;
    get ports(): string[];
    get project(): string;
    get pscConnectionId(): string;
    get pscConnectionStatus(): string;
    get recreateClosedPsc(): cdktf.IResolvable;
    get region(): string;
    get selfLink(): string;
    private _serviceDirectoryRegistrations;
    get serviceDirectoryRegistrations(): DataGoogleComputeForwardingRulesRulesServiceDirectoryRegistrationsList;
    get serviceLabel(): string;
    get serviceName(): string;
    get sourceIpRanges(): string[];
    get subnetwork(): string;
    get target(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
}
export declare class DataGoogleComputeForwardingRulesRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeForwardingRulesRulesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_forwarding_rules google_compute_forwarding_rules}
*/
export declare class DataGoogleComputeForwardingRules extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_forwarding_rules";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeForwardingRules resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeForwardingRules to import
    * @param importFromId The id of the existing DataGoogleComputeForwardingRules that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_forwarding_rules#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeForwardingRules to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_forwarding_rules google_compute_forwarding_rules} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeForwardingRulesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeForwardingRulesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _rules;
    get rules(): DataGoogleComputeForwardingRulesRulesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
