/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeInstanceGroupManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager#id DataGoogleComputeInstanceGroupManager#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the instance group manager. Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager#name DataGoogleComputeInstanceGroupManager#name}
    */
    readonly name?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager#project DataGoogleComputeInstanceGroupManager#project}
    */
    readonly project?: string;
    /**
    * The URL of the created resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager#self_link DataGoogleComputeInstanceGroupManager#self_link}
    */
    readonly selfLink?: string;
    /**
    * The zone that instances in this group should be created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager#zone DataGoogleComputeInstanceGroupManager#zone}
    */
    readonly zone?: string;
}
export interface DataGoogleComputeInstanceGroupManagerAllInstancesConfig {
}
export declare function dataGoogleComputeInstanceGroupManagerAllInstancesConfigToTerraform(struct?: DataGoogleComputeInstanceGroupManagerAllInstancesConfig): any;
export declare function dataGoogleComputeInstanceGroupManagerAllInstancesConfigToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerAllInstancesConfig): any;
export declare class DataGoogleComputeInstanceGroupManagerAllInstancesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerAllInstancesConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerAllInstancesConfig | undefined);
    private _labels;
    get labels(): cdktf.StringMap;
    private _metadata;
    get metadata(): cdktf.StringMap;
}
export declare class DataGoogleComputeInstanceGroupManagerAllInstancesConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerAllInstancesConfigOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerAutoHealingPolicies {
}
export declare function dataGoogleComputeInstanceGroupManagerAutoHealingPoliciesToTerraform(struct?: DataGoogleComputeInstanceGroupManagerAutoHealingPolicies): any;
export declare function dataGoogleComputeInstanceGroupManagerAutoHealingPoliciesToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerAutoHealingPolicies): any;
export declare class DataGoogleComputeInstanceGroupManagerAutoHealingPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerAutoHealingPolicies | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerAutoHealingPolicies | undefined);
    get healthCheck(): string;
    get initialDelaySec(): number;
}
export declare class DataGoogleComputeInstanceGroupManagerAutoHealingPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerAutoHealingPoliciesOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicy {
}
export declare function dataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicyToTerraform(struct?: DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicy): any;
export declare function dataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicyToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicy): any;
export declare class DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicy | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicy | undefined);
    get defaultActionOnFailure(): string;
    get forceUpdateOnRepair(): string;
}
export declare class DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicyOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerNamedPort {
}
export declare function dataGoogleComputeInstanceGroupManagerNamedPortToTerraform(struct?: DataGoogleComputeInstanceGroupManagerNamedPort): any;
export declare function dataGoogleComputeInstanceGroupManagerNamedPortToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerNamedPort): any;
export declare class DataGoogleComputeInstanceGroupManagerNamedPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerNamedPort | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerNamedPort | undefined);
    get name(): string;
    get port(): number;
}
export declare class DataGoogleComputeInstanceGroupManagerNamedPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerNamedPortOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatefulDisk {
}
export declare function dataGoogleComputeInstanceGroupManagerStatefulDiskToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatefulDisk): any;
export declare function dataGoogleComputeInstanceGroupManagerStatefulDiskToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatefulDisk): any;
export declare class DataGoogleComputeInstanceGroupManagerStatefulDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatefulDisk | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatefulDisk | undefined);
    get deleteRule(): string;
    get deviceName(): string;
}
export declare class DataGoogleComputeInstanceGroupManagerStatefulDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatefulDiskOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatefulExternalIp {
}
export declare function dataGoogleComputeInstanceGroupManagerStatefulExternalIpToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatefulExternalIp): any;
export declare function dataGoogleComputeInstanceGroupManagerStatefulExternalIpToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatefulExternalIp): any;
export declare class DataGoogleComputeInstanceGroupManagerStatefulExternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatefulExternalIp | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatefulExternalIp | undefined);
    get deleteRule(): string;
    get interfaceName(): string;
}
export declare class DataGoogleComputeInstanceGroupManagerStatefulExternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatefulExternalIpOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatefulInternalIp {
}
export declare function dataGoogleComputeInstanceGroupManagerStatefulInternalIpToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatefulInternalIp): any;
export declare function dataGoogleComputeInstanceGroupManagerStatefulInternalIpToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatefulInternalIp): any;
export declare class DataGoogleComputeInstanceGroupManagerStatefulInternalIpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatefulInternalIp | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatefulInternalIp | undefined);
    get deleteRule(): string;
    get interfaceName(): string;
}
export declare class DataGoogleComputeInstanceGroupManagerStatefulInternalIpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatefulInternalIpOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfig {
}
export declare function dataGoogleComputeInstanceGroupManagerStatusAllInstancesConfigToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfig): any;
export declare function dataGoogleComputeInstanceGroupManagerStatusAllInstancesConfigToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfig): any;
export declare class DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfig | undefined);
    get effective(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfigOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs {
}
export declare function dataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs): any;
export declare function dataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs): any;
export declare class DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined);
    get allEffective(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatusStateful {
}
export declare function dataGoogleComputeInstanceGroupManagerStatusStatefulToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusStateful): any;
export declare function dataGoogleComputeInstanceGroupManagerStatusStatefulToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusStateful): any;
export declare class DataGoogleComputeInstanceGroupManagerStatusStatefulOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatusStateful | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatusStateful | undefined);
    get hasStatefulConfig(): cdktf.IResolvable;
    private _perInstanceConfigs;
    get perInstanceConfigs(): DataGoogleComputeInstanceGroupManagerStatusStatefulPerInstanceConfigsList;
}
export declare class DataGoogleComputeInstanceGroupManagerStatusStatefulList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatusStatefulOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatusVersionTarget {
}
export declare function dataGoogleComputeInstanceGroupManagerStatusVersionTargetToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusVersionTarget): any;
export declare function dataGoogleComputeInstanceGroupManagerStatusVersionTargetToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatusVersionTarget): any;
export declare class DataGoogleComputeInstanceGroupManagerStatusVersionTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatusVersionTarget | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatusVersionTarget | undefined);
    get isReached(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceGroupManagerStatusVersionTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatusVersionTargetOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerStatus {
}
export declare function dataGoogleComputeInstanceGroupManagerStatusToTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatus): any;
export declare function dataGoogleComputeInstanceGroupManagerStatusToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerStatus): any;
export declare class DataGoogleComputeInstanceGroupManagerStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerStatus | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerStatus | undefined);
    private _allInstancesConfig;
    get allInstancesConfig(): DataGoogleComputeInstanceGroupManagerStatusAllInstancesConfigList;
    get isStable(): cdktf.IResolvable;
    private _stateful;
    get stateful(): DataGoogleComputeInstanceGroupManagerStatusStatefulList;
    private _versionTarget;
    get versionTarget(): DataGoogleComputeInstanceGroupManagerStatusVersionTargetList;
}
export declare class DataGoogleComputeInstanceGroupManagerStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerStatusOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerUpdatePolicy {
}
export declare function dataGoogleComputeInstanceGroupManagerUpdatePolicyToTerraform(struct?: DataGoogleComputeInstanceGroupManagerUpdatePolicy): any;
export declare function dataGoogleComputeInstanceGroupManagerUpdatePolicyToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerUpdatePolicy): any;
export declare class DataGoogleComputeInstanceGroupManagerUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerUpdatePolicy | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerUpdatePolicy | undefined);
    get maxSurgeFixed(): number;
    get maxSurgePercent(): number;
    get maxUnavailableFixed(): number;
    get maxUnavailablePercent(): number;
    get minReadySec(): number;
    get minimalAction(): string;
    get mostDisruptiveAllowedAction(): string;
    get replacementMethod(): string;
    get type(): string;
}
export declare class DataGoogleComputeInstanceGroupManagerUpdatePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerUpdatePolicyOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerVersionTargetSize {
}
export declare function dataGoogleComputeInstanceGroupManagerVersionTargetSizeToTerraform(struct?: DataGoogleComputeInstanceGroupManagerVersionTargetSize): any;
export declare function dataGoogleComputeInstanceGroupManagerVersionTargetSizeToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerVersionTargetSize): any;
export declare class DataGoogleComputeInstanceGroupManagerVersionTargetSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerVersionTargetSize | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerVersionTargetSize | undefined);
    get fixed(): number;
    get percent(): number;
}
export declare class DataGoogleComputeInstanceGroupManagerVersionTargetSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerVersionTargetSizeOutputReference;
}
export interface DataGoogleComputeInstanceGroupManagerVersion {
}
export declare function dataGoogleComputeInstanceGroupManagerVersionToTerraform(struct?: DataGoogleComputeInstanceGroupManagerVersion): any;
export declare function dataGoogleComputeInstanceGroupManagerVersionToHclTerraform(struct?: DataGoogleComputeInstanceGroupManagerVersion): any;
export declare class DataGoogleComputeInstanceGroupManagerVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGroupManagerVersion | undefined;
    set internalValue(value: DataGoogleComputeInstanceGroupManagerVersion | undefined);
    get instanceTemplate(): string;
    get name(): string;
    private _targetSize;
    get targetSize(): DataGoogleComputeInstanceGroupManagerVersionTargetSizeList;
}
export declare class DataGoogleComputeInstanceGroupManagerVersionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGroupManagerVersionOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager google_compute_instance_group_manager}
*/
export declare class DataGoogleComputeInstanceGroupManager extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_instance_group_manager";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeInstanceGroupManager resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeInstanceGroupManager to import
    * @param importFromId The id of the existing DataGoogleComputeInstanceGroupManager that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeInstanceGroupManager to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_group_manager google_compute_instance_group_manager} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeInstanceGroupManagerConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeInstanceGroupManagerConfig);
    private _allInstancesConfig;
    get allInstancesConfig(): DataGoogleComputeInstanceGroupManagerAllInstancesConfigList;
    private _autoHealingPolicies;
    get autoHealingPolicies(): DataGoogleComputeInstanceGroupManagerAutoHealingPoliciesList;
    get baseInstanceName(): string;
    get creationTimestamp(): string;
    get description(): string;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceGroup(): string;
    private _instanceLifecyclePolicy;
    get instanceLifecyclePolicy(): DataGoogleComputeInstanceGroupManagerInstanceLifecyclePolicyList;
    get listManagedInstancesResults(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namedPort;
    get namedPort(): DataGoogleComputeInstanceGroupManagerNamedPortList;
    get operation(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selfLink?;
    get selfLink(): string;
    set selfLink(value: string);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    private _statefulDisk;
    get statefulDisk(): DataGoogleComputeInstanceGroupManagerStatefulDiskList;
    private _statefulExternalIp;
    get statefulExternalIp(): DataGoogleComputeInstanceGroupManagerStatefulExternalIpList;
    private _statefulInternalIp;
    get statefulInternalIp(): DataGoogleComputeInstanceGroupManagerStatefulInternalIpList;
    private _status;
    get status(): DataGoogleComputeInstanceGroupManagerStatusList;
    get targetPools(): string[];
    get targetSize(): number;
    private _updatePolicy;
    get updatePolicy(): DataGoogleComputeInstanceGroupManagerUpdatePolicyList;
    private _version;
    get version(): DataGoogleComputeInstanceGroupManagerVersionList;
    get waitForInstances(): cdktf.IResolvable;
    get waitForInstancesStatus(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
