/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#filter DataGoogleComputeInstanceTemplate#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#id DataGoogleComputeInstanceTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#most_recent DataGoogleComputeInstanceTemplate#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#name DataGoogleComputeInstanceTemplate#name}
    */
    readonly name?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#project DataGoogleComputeInstanceTemplate#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#self_link_unique DataGoogleComputeInstanceTemplate#self_link_unique}
    */
    readonly selfLinkUnique?: string;
}
export interface DataGoogleComputeInstanceTemplateAdvancedMachineFeatures {
}
export declare function dataGoogleComputeInstanceTemplateAdvancedMachineFeaturesToTerraform(struct?: DataGoogleComputeInstanceTemplateAdvancedMachineFeatures): any;
export declare function dataGoogleComputeInstanceTemplateAdvancedMachineFeaturesToHclTerraform(struct?: DataGoogleComputeInstanceTemplateAdvancedMachineFeatures): any;
export declare class DataGoogleComputeInstanceTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateAdvancedMachineFeatures | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateAdvancedMachineFeatures | undefined);
    get enableNestedVirtualization(): cdktf.IResolvable;
    get threadsPerCore(): number;
    get visibleCoreCount(): number;
}
export declare class DataGoogleComputeInstanceTemplateAdvancedMachineFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateAdvancedMachineFeaturesOutputReference;
}
export interface DataGoogleComputeInstanceTemplateConfidentialInstanceConfig {
}
export declare function dataGoogleComputeInstanceTemplateConfidentialInstanceConfigToTerraform(struct?: DataGoogleComputeInstanceTemplateConfidentialInstanceConfig): any;
export declare function dataGoogleComputeInstanceTemplateConfidentialInstanceConfigToHclTerraform(struct?: DataGoogleComputeInstanceTemplateConfidentialInstanceConfig): any;
export declare class DataGoogleComputeInstanceTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateConfidentialInstanceConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateConfidentialInstanceConfig | undefined);
    get confidentialInstanceType(): string;
    get enableConfidentialCompute(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceTemplateConfidentialInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateConfidentialInstanceConfigOutputReference;
}
export interface DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey {
}
export declare function dataGoogleComputeInstanceTemplateDiskDiskEncryptionKeyToTerraform(struct?: DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey): any;
export declare function dataGoogleComputeInstanceTemplateDiskDiskEncryptionKeyToHclTerraform(struct?: DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey): any;
export declare class DataGoogleComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateDiskDiskEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
}
export declare class DataGoogleComputeInstanceTemplateDiskDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateDiskDiskEncryptionKeyOutputReference;
}
export interface DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKey {
}
export declare function dataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKeyToTerraform(struct?: DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKey): any;
export declare function dataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKeyToHclTerraform(struct?: DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKey): any;
export declare class DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
}
export declare class DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKeyOutputReference;
}
export interface DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKey {
}
export declare function dataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKeyToTerraform(struct?: DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKey): any;
export declare function dataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKey): any;
export declare class DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
}
export declare class DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference;
}
export interface DataGoogleComputeInstanceTemplateDisk {
}
export declare function dataGoogleComputeInstanceTemplateDiskToTerraform(struct?: DataGoogleComputeInstanceTemplateDisk): any;
export declare function dataGoogleComputeInstanceTemplateDiskToHclTerraform(struct?: DataGoogleComputeInstanceTemplateDisk): any;
export declare class DataGoogleComputeInstanceTemplateDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateDisk | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateDisk | undefined);
    get autoDelete(): cdktf.IResolvable;
    get boot(): cdktf.IResolvable;
    get deviceName(): string;
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataGoogleComputeInstanceTemplateDiskDiskEncryptionKeyList;
    get diskName(): string;
    get diskSizeGb(): number;
    get diskType(): string;
    get interface(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get mode(): string;
    get provisionedIops(): number;
    private _resourceManagerTags;
    get resourceManagerTags(): cdktf.StringMap;
    get resourcePolicies(): string[];
    get source(): string;
    get sourceImage(): string;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): DataGoogleComputeInstanceTemplateDiskSourceImageEncryptionKeyList;
    get sourceSnapshot(): string;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): DataGoogleComputeInstanceTemplateDiskSourceSnapshotEncryptionKeyList;
    get type(): string;
}
export declare class DataGoogleComputeInstanceTemplateDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateDiskOutputReference;
}
export interface DataGoogleComputeInstanceTemplateGuestAccelerator {
}
export declare function dataGoogleComputeInstanceTemplateGuestAcceleratorToTerraform(struct?: DataGoogleComputeInstanceTemplateGuestAccelerator): any;
export declare function dataGoogleComputeInstanceTemplateGuestAcceleratorToHclTerraform(struct?: DataGoogleComputeInstanceTemplateGuestAccelerator): any;
export declare class DataGoogleComputeInstanceTemplateGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateGuestAccelerator | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateGuestAccelerator | undefined);
    get count(): number;
    get type(): string;
}
export declare class DataGoogleComputeInstanceTemplateGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateGuestAcceleratorOutputReference;
}
export interface DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig {
}
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfigToTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig): any;
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfigToHclTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig): any;
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfig | undefined);
    get natIp(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfigOutputReference;
}
export interface DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange {
}
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange): any;
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRangeToHclTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange): any;
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRange | undefined);
    get ipCidrRange(): string;
    get subnetworkRangeName(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference;
}
export interface DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig {
}
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig): any;
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigToHclTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig): any;
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfig | undefined);
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    get name(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface DataGoogleComputeInstanceTemplateNetworkInterface {
}
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceToTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterface): any;
export declare function dataGoogleComputeInstanceTemplateNetworkInterfaceToHclTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkInterface): any;
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateNetworkInterface | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateNetworkInterface | undefined);
    private _accessConfig;
    get accessConfig(): DataGoogleComputeInstanceTemplateNetworkInterfaceAccessConfigList;
    private _aliasIpRange;
    get aliasIpRange(): DataGoogleComputeInstanceTemplateNetworkInterfaceAliasIpRangeList;
    get internalIpv6PrefixLength(): number;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): DataGoogleComputeInstanceTemplateNetworkInterfaceIpv6AccessConfigList;
    get ipv6AccessType(): string;
    get ipv6Address(): string;
    get name(): string;
    get network(): string;
    get networkAttachment(): string;
    get networkIp(): string;
    get nicType(): string;
    get queueCount(): number;
    get stackType(): string;
    get subnetwork(): string;
    get subnetworkProject(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateNetworkInterfaceOutputReference;
}
export interface DataGoogleComputeInstanceTemplateNetworkPerformanceConfig {
}
export declare function dataGoogleComputeInstanceTemplateNetworkPerformanceConfigToTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkPerformanceConfig): any;
export declare function dataGoogleComputeInstanceTemplateNetworkPerformanceConfigToHclTerraform(struct?: DataGoogleComputeInstanceTemplateNetworkPerformanceConfig): any;
export declare class DataGoogleComputeInstanceTemplateNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateNetworkPerformanceConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateNetworkPerformanceConfig | undefined);
    get totalEgressBandwidthTier(): string;
}
export declare class DataGoogleComputeInstanceTemplateNetworkPerformanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateNetworkPerformanceConfigOutputReference;
}
export interface DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation {
}
export declare function dataGoogleComputeInstanceTemplateReservationAffinitySpecificReservationToTerraform(struct?: DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation): any;
export declare function dataGoogleComputeInstanceTemplateReservationAffinitySpecificReservationToHclTerraform(struct?: DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation): any;
export declare class DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservation | undefined);
    get key(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservationOutputReference;
}
export interface DataGoogleComputeInstanceTemplateReservationAffinity {
}
export declare function dataGoogleComputeInstanceTemplateReservationAffinityToTerraform(struct?: DataGoogleComputeInstanceTemplateReservationAffinity): any;
export declare function dataGoogleComputeInstanceTemplateReservationAffinityToHclTerraform(struct?: DataGoogleComputeInstanceTemplateReservationAffinity): any;
export declare class DataGoogleComputeInstanceTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateReservationAffinity | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateReservationAffinity | undefined);
    private _specificReservation;
    get specificReservation(): DataGoogleComputeInstanceTemplateReservationAffinitySpecificReservationList;
    get type(): string;
}
export declare class DataGoogleComputeInstanceTemplateReservationAffinityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateReservationAffinityOutputReference;
}
export interface DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeout {
}
export declare function dataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeoutToTerraform(struct?: DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeout): any;
export declare function dataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeoutToHclTerraform(struct?: DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeout): any;
export declare class DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeout | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeout | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference;
}
export interface DataGoogleComputeInstanceTemplateSchedulingMaxRunDuration {
}
export declare function dataGoogleComputeInstanceTemplateSchedulingMaxRunDurationToTerraform(struct?: DataGoogleComputeInstanceTemplateSchedulingMaxRunDuration): any;
export declare function dataGoogleComputeInstanceTemplateSchedulingMaxRunDurationToHclTerraform(struct?: DataGoogleComputeInstanceTemplateSchedulingMaxRunDuration): any;
export declare class DataGoogleComputeInstanceTemplateSchedulingMaxRunDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateSchedulingMaxRunDuration | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateSchedulingMaxRunDuration | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeInstanceTemplateSchedulingMaxRunDurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateSchedulingMaxRunDurationOutputReference;
}
export interface DataGoogleComputeInstanceTemplateSchedulingNodeAffinities {
}
export declare function dataGoogleComputeInstanceTemplateSchedulingNodeAffinitiesToTerraform(struct?: DataGoogleComputeInstanceTemplateSchedulingNodeAffinities): any;
export declare function dataGoogleComputeInstanceTemplateSchedulingNodeAffinitiesToHclTerraform(struct?: DataGoogleComputeInstanceTemplateSchedulingNodeAffinities): any;
export declare class DataGoogleComputeInstanceTemplateSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateSchedulingNodeAffinities | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateSchedulingNodeAffinities | undefined);
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceTemplateSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateSchedulingNodeAffinitiesOutputReference;
}
export interface DataGoogleComputeInstanceTemplateScheduling {
}
export declare function dataGoogleComputeInstanceTemplateSchedulingToTerraform(struct?: DataGoogleComputeInstanceTemplateScheduling): any;
export declare function dataGoogleComputeInstanceTemplateSchedulingToHclTerraform(struct?: DataGoogleComputeInstanceTemplateScheduling): any;
export declare class DataGoogleComputeInstanceTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateScheduling | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateScheduling | undefined);
    get automaticRestart(): cdktf.IResolvable;
    get instanceTerminationAction(): string;
    private _localSsdRecoveryTimeout;
    get localSsdRecoveryTimeout(): DataGoogleComputeInstanceTemplateSchedulingLocalSsdRecoveryTimeoutList;
    get maintenanceInterval(): string;
    private _maxRunDuration;
    get maxRunDuration(): DataGoogleComputeInstanceTemplateSchedulingMaxRunDurationList;
    get minNodeCpus(): number;
    private _nodeAffinities;
    get nodeAffinities(): DataGoogleComputeInstanceTemplateSchedulingNodeAffinitiesList;
    get onHostMaintenance(): string;
    get preemptible(): cdktf.IResolvable;
    get provisioningModel(): string;
}
export declare class DataGoogleComputeInstanceTemplateSchedulingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateSchedulingOutputReference;
}
export interface DataGoogleComputeInstanceTemplateServiceAccount {
}
export declare function dataGoogleComputeInstanceTemplateServiceAccountToTerraform(struct?: DataGoogleComputeInstanceTemplateServiceAccount): any;
export declare function dataGoogleComputeInstanceTemplateServiceAccountToHclTerraform(struct?: DataGoogleComputeInstanceTemplateServiceAccount): any;
export declare class DataGoogleComputeInstanceTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateServiceAccount | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateServiceAccount | undefined);
    get email(): string;
    get scopes(): string[];
}
export declare class DataGoogleComputeInstanceTemplateServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateServiceAccountOutputReference;
}
export interface DataGoogleComputeInstanceTemplateShieldedInstanceConfig {
}
export declare function dataGoogleComputeInstanceTemplateShieldedInstanceConfigToTerraform(struct?: DataGoogleComputeInstanceTemplateShieldedInstanceConfig): any;
export declare function dataGoogleComputeInstanceTemplateShieldedInstanceConfigToHclTerraform(struct?: DataGoogleComputeInstanceTemplateShieldedInstanceConfig): any;
export declare class DataGoogleComputeInstanceTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceTemplateShieldedInstanceConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceTemplateShieldedInstanceConfig | undefined);
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
    get enableVtpm(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceTemplateShieldedInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceTemplateShieldedInstanceConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template google_compute_instance_template}
*/
export declare class DataGoogleComputeInstanceTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_instance_template";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeInstanceTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeInstanceTemplate to import
    * @param importFromId The id of the existing DataGoogleComputeInstanceTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeInstanceTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_instance_template google_compute_instance_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeInstanceTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeInstanceTemplateConfig);
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): DataGoogleComputeInstanceTemplateAdvancedMachineFeaturesList;
    get canIpForward(): cdktf.IResolvable;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): DataGoogleComputeInstanceTemplateConfidentialInstanceConfigList;
    get description(): string;
    private _disk;
    get disk(): DataGoogleComputeInstanceTemplateDiskList;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get enableDisplay(): cdktf.IResolvable;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): DataGoogleComputeInstanceTemplateGuestAcceleratorList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceDescription(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get machineType(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    get metadataFingerprint(): string;
    get metadataStartupScript(): string;
    get minCpuPlatform(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get namePrefix(): string;
    private _networkInterface;
    get networkInterface(): DataGoogleComputeInstanceTemplateNetworkInterfaceList;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): DataGoogleComputeInstanceTemplateNetworkPerformanceConfigList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get region(): string;
    private _reservationAffinity;
    get reservationAffinity(): DataGoogleComputeInstanceTemplateReservationAffinityList;
    private _resourceManagerTags;
    get resourceManagerTags(): cdktf.StringMap;
    get resourcePolicies(): string[];
    private _scheduling;
    get scheduling(): DataGoogleComputeInstanceTemplateSchedulingList;
    get selfLink(): string;
    private _selfLinkUnique?;
    get selfLinkUnique(): string;
    set selfLinkUnique(value: string);
    resetSelfLinkUnique(): void;
    get selfLinkUniqueInput(): string | undefined;
    private _serviceAccount;
    get serviceAccount(): DataGoogleComputeInstanceTemplateServiceAccountList;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataGoogleComputeInstanceTemplateShieldedInstanceConfigList;
    get tags(): string[];
    get tagsFingerprint(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
