/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeMachineTypesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types#filter DataGoogleComputeMachineTypes#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types#id DataGoogleComputeMachineTypes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Project ID for this request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types#project DataGoogleComputeMachineTypes#project}
    */
    readonly project?: string;
    /**
    * The name of the zone for this request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types#zone DataGoogleComputeMachineTypes#zone}
    */
    readonly zone?: string;
}
export interface DataGoogleComputeMachineTypesMachineTypesAccelerators {
}
export declare function dataGoogleComputeMachineTypesMachineTypesAcceleratorsToTerraform(struct?: DataGoogleComputeMachineTypesMachineTypesAccelerators): any;
export declare function dataGoogleComputeMachineTypesMachineTypesAcceleratorsToHclTerraform(struct?: DataGoogleComputeMachineTypesMachineTypesAccelerators): any;
export declare class DataGoogleComputeMachineTypesMachineTypesAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeMachineTypesMachineTypesAccelerators | undefined;
    set internalValue(value: DataGoogleComputeMachineTypesMachineTypesAccelerators | undefined);
    get guestAcceleratorCount(): number;
    get guestAcceleratorType(): string;
}
export declare class DataGoogleComputeMachineTypesMachineTypesAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeMachineTypesMachineTypesAcceleratorsOutputReference;
}
export interface DataGoogleComputeMachineTypesMachineTypesBundledLocalSsds {
}
export declare function dataGoogleComputeMachineTypesMachineTypesBundledLocalSsdsToTerraform(struct?: DataGoogleComputeMachineTypesMachineTypesBundledLocalSsds): any;
export declare function dataGoogleComputeMachineTypesMachineTypesBundledLocalSsdsToHclTerraform(struct?: DataGoogleComputeMachineTypesMachineTypesBundledLocalSsds): any;
export declare class DataGoogleComputeMachineTypesMachineTypesBundledLocalSsdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeMachineTypesMachineTypesBundledLocalSsds | undefined;
    set internalValue(value: DataGoogleComputeMachineTypesMachineTypesBundledLocalSsds | undefined);
    get defaultInterface(): string;
    get partitionCount(): number;
}
export declare class DataGoogleComputeMachineTypesMachineTypesBundledLocalSsdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeMachineTypesMachineTypesBundledLocalSsdsOutputReference;
}
export interface DataGoogleComputeMachineTypesMachineTypesDeprecated {
}
export declare function dataGoogleComputeMachineTypesMachineTypesDeprecatedToTerraform(struct?: DataGoogleComputeMachineTypesMachineTypesDeprecated): any;
export declare function dataGoogleComputeMachineTypesMachineTypesDeprecatedToHclTerraform(struct?: DataGoogleComputeMachineTypesMachineTypesDeprecated): any;
export declare class DataGoogleComputeMachineTypesMachineTypesDeprecatedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeMachineTypesMachineTypesDeprecated | undefined;
    set internalValue(value: DataGoogleComputeMachineTypesMachineTypesDeprecated | undefined);
    get replacement(): string;
    get state(): string;
}
export declare class DataGoogleComputeMachineTypesMachineTypesDeprecatedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeMachineTypesMachineTypesDeprecatedOutputReference;
}
export interface DataGoogleComputeMachineTypesMachineTypes {
}
export declare function dataGoogleComputeMachineTypesMachineTypesToTerraform(struct?: DataGoogleComputeMachineTypesMachineTypes): any;
export declare function dataGoogleComputeMachineTypesMachineTypesToHclTerraform(struct?: DataGoogleComputeMachineTypesMachineTypes): any;
export declare class DataGoogleComputeMachineTypesMachineTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeMachineTypesMachineTypes | undefined;
    set internalValue(value: DataGoogleComputeMachineTypesMachineTypes | undefined);
    private _accelerators;
    get accelerators(): DataGoogleComputeMachineTypesMachineTypesAcceleratorsList;
    private _bundledLocalSsds;
    get bundledLocalSsds(): DataGoogleComputeMachineTypesMachineTypesBundledLocalSsdsList;
    private _deprecated;
    get deprecated(): DataGoogleComputeMachineTypesMachineTypesDeprecatedList;
    get description(): string;
    get guestCpus(): number;
    get isSharedCpus(): cdktf.IResolvable;
    get maximumPersistentDisks(): number;
    get maximumPersistentDisksSizeGb(): number;
    get memoryMb(): number;
    get name(): string;
    get selfLink(): string;
}
export declare class DataGoogleComputeMachineTypesMachineTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeMachineTypesMachineTypesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types google_compute_machine_types}
*/
export declare class DataGoogleComputeMachineTypes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_machine_types";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeMachineTypes resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeMachineTypes to import
    * @param importFromId The id of the existing DataGoogleComputeMachineTypes that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeMachineTypes to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_machine_types google_compute_machine_types} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeMachineTypesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeMachineTypesConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _machineTypes;
    get machineTypes(): DataGoogleComputeMachineTypesMachineTypesList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
