/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeNetworkPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering#id DataGoogleComputeNetworkPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering#name DataGoogleComputeNetworkPeering#name}
    */
    readonly name: string;
    /**
    * The primary network of the peering.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering#network DataGoogleComputeNetworkPeering#network}
    */
    readonly network: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering#timeouts DataGoogleComputeNetworkPeering#timeouts}
    */
    readonly timeouts?: DataGoogleComputeNetworkPeeringTimeouts;
}
export interface DataGoogleComputeNetworkPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering#read DataGoogleComputeNetworkPeering#read}
    */
    readonly read?: string;
}
export declare function dataGoogleComputeNetworkPeeringTimeoutsToTerraform(struct?: DataGoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare function dataGoogleComputeNetworkPeeringTimeoutsToHclTerraform(struct?: DataGoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable): any;
export declare class DataGoogleComputeNetworkPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataGoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataGoogleComputeNetworkPeeringTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering google_compute_network_peering}
*/
export declare class DataGoogleComputeNetworkPeering extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_network_peering";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeNetworkPeering resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeNetworkPeering to import
    * @param importFromId The id of the existing DataGoogleComputeNetworkPeering that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeNetworkPeering to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_network_peering google_compute_network_peering} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeNetworkPeeringConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeNetworkPeeringConfig);
    get exportCustomRoutes(): cdktf.IResolvable;
    get exportSubnetRoutesWithPublicIp(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get importCustomRoutes(): cdktf.IResolvable;
    get importSubnetRoutesWithPublicIp(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    get peerNetwork(): string;
    get stackType(): string;
    get state(): string;
    get stateDetails(): string;
    private _timeouts;
    get timeouts(): DataGoogleComputeNetworkPeeringTimeoutsOutputReference;
    putTimeouts(value: DataGoogleComputeNetworkPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataGoogleComputeNetworkPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
