/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk#id DataGoogleComputeRegionDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk#name DataGoogleComputeRegionDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk#project DataGoogleComputeRegionDisk#project}
    */
    readonly project?: string;
    /**
    * A reference to the region where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk#region DataGoogleComputeRegionDisk#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeRegionDiskAsyncPrimaryDisk {
}
export declare function dataGoogleComputeRegionDiskAsyncPrimaryDiskToTerraform(struct?: DataGoogleComputeRegionDiskAsyncPrimaryDisk): any;
export declare function dataGoogleComputeRegionDiskAsyncPrimaryDiskToHclTerraform(struct?: DataGoogleComputeRegionDiskAsyncPrimaryDisk): any;
export declare class DataGoogleComputeRegionDiskAsyncPrimaryDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionDiskAsyncPrimaryDisk | undefined;
    set internalValue(value: DataGoogleComputeRegionDiskAsyncPrimaryDisk | undefined);
    get disk(): string;
}
export declare class DataGoogleComputeRegionDiskAsyncPrimaryDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionDiskAsyncPrimaryDiskOutputReference;
}
export interface DataGoogleComputeRegionDiskDiskEncryptionKey {
}
export declare function dataGoogleComputeRegionDiskDiskEncryptionKeyToTerraform(struct?: DataGoogleComputeRegionDiskDiskEncryptionKey): any;
export declare function dataGoogleComputeRegionDiskDiskEncryptionKeyToHclTerraform(struct?: DataGoogleComputeRegionDiskDiskEncryptionKey): any;
export declare class DataGoogleComputeRegionDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionDiskDiskEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeRegionDiskDiskEncryptionKey | undefined);
    get kmsKeyName(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeRegionDiskDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionDiskDiskEncryptionKeyOutputReference;
}
export interface DataGoogleComputeRegionDiskGuestOsFeatures {
}
export declare function dataGoogleComputeRegionDiskGuestOsFeaturesToTerraform(struct?: DataGoogleComputeRegionDiskGuestOsFeatures): any;
export declare function dataGoogleComputeRegionDiskGuestOsFeaturesToHclTerraform(struct?: DataGoogleComputeRegionDiskGuestOsFeatures): any;
export declare class DataGoogleComputeRegionDiskGuestOsFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionDiskGuestOsFeatures | undefined;
    set internalValue(value: DataGoogleComputeRegionDiskGuestOsFeatures | undefined);
    get type(): string;
}
export declare class DataGoogleComputeRegionDiskGuestOsFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionDiskGuestOsFeaturesOutputReference;
}
export interface DataGoogleComputeRegionDiskSourceSnapshotEncryptionKey {
}
export declare function dataGoogleComputeRegionDiskSourceSnapshotEncryptionKeyToTerraform(struct?: DataGoogleComputeRegionDiskSourceSnapshotEncryptionKey): any;
export declare function dataGoogleComputeRegionDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: DataGoogleComputeRegionDiskSourceSnapshotEncryptionKey): any;
export declare class DataGoogleComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeRegionDiskSourceSnapshotEncryptionKey | undefined);
    get kmsKeyName(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeRegionDiskSourceSnapshotEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk google_compute_region_disk}
*/
export declare class DataGoogleComputeRegionDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_region_disk";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeRegionDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeRegionDisk to import
    * @param importFromId The id of the existing DataGoogleComputeRegionDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeRegionDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_disk google_compute_region_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRegionDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeRegionDiskConfig);
    private _asyncPrimaryDisk;
    get asyncPrimaryDisk(): DataGoogleComputeRegionDiskAsyncPrimaryDiskList;
    get creationTimestamp(): string;
    get description(): string;
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataGoogleComputeRegionDiskDiskEncryptionKeyList;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _guestOsFeatures;
    get guestOsFeatures(): DataGoogleComputeRegionDiskGuestOsFeaturesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interface(): string;
    get labelFingerprint(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    get licenses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get physicalBlockSizeBytes(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get replicaZones(): string[];
    get selfLink(): string;
    get size(): number;
    get snapshot(): string;
    get sourceDisk(): string;
    get sourceDiskId(): string;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): DataGoogleComputeRegionDiskSourceSnapshotEncryptionKeyList;
    get sourceSnapshotId(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get type(): string;
    get users(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
