/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionInstanceTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#filter DataGoogleComputeRegionInstanceTemplate#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#id DataGoogleComputeRegionInstanceTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#most_recent DataGoogleComputeRegionInstanceTemplate#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * The name of the instance template. If you leave this blank, Terraform will auto-generate a unique name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#name DataGoogleComputeRegionInstanceTemplate#name}
    */
    readonly name?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#project DataGoogleComputeRegionInstanceTemplate#project}
    */
    readonly project?: string;
    /**
    * The region in which the instance template is located. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#region DataGoogleComputeRegionInstanceTemplate#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeatures {
}
export declare function dataGoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeatures): any;
export declare function dataGoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeatures): any;
export declare class DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeatures | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeatures | undefined);
    get enableNestedVirtualization(): cdktf.IResolvable;
    get threadsPerCore(): number;
    get visibleCoreCount(): number;
}
export declare class DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfig {
}
export declare function dataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfigToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfig): any;
export declare function dataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfigToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfig): any;
export declare class DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfig | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfig | undefined);
    get confidentialInstanceType(): string;
    get enableConfidentialCompute(): cdktf.IResolvable;
}
export declare class DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfigOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey {
}
export declare function dataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey): any;
export declare function dataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey): any;
export declare class DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey {
}
export declare function dataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey): any;
export declare function dataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey): any;
export declare class DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey {
}
export declare function dataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey): any;
export declare function dataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey): any;
export declare class DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateDisk {
}
export declare function dataGoogleComputeRegionInstanceTemplateDiskToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDisk): any;
export declare function dataGoogleComputeRegionInstanceTemplateDiskToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateDisk): any;
export declare class DataGoogleComputeRegionInstanceTemplateDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateDisk | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateDisk | undefined);
    get autoDelete(): cdktf.IResolvable;
    get boot(): cdktf.IResolvable;
    get deviceName(): string;
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataGoogleComputeRegionInstanceTemplateDiskDiskEncryptionKeyList;
    get diskName(): string;
    get diskSizeGb(): number;
    get diskType(): string;
    get interface(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get mode(): string;
    get provisionedIops(): number;
    private _resourceManagerTags;
    get resourceManagerTags(): cdktf.StringMap;
    get resourcePolicies(): string[];
    get source(): string;
    get sourceImage(): string;
    private _sourceImageEncryptionKey;
    get sourceImageEncryptionKey(): DataGoogleComputeRegionInstanceTemplateDiskSourceImageEncryptionKeyList;
    get sourceSnapshot(): string;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): DataGoogleComputeRegionInstanceTemplateDiskSourceSnapshotEncryptionKeyList;
    get type(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateDiskOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateGuestAccelerator {
}
export declare function dataGoogleComputeRegionInstanceTemplateGuestAcceleratorToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateGuestAccelerator): any;
export declare function dataGoogleComputeRegionInstanceTemplateGuestAcceleratorToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateGuestAccelerator): any;
export declare class DataGoogleComputeRegionInstanceTemplateGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateGuestAccelerator | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateGuestAccelerator | undefined);
    get count(): number;
    get type(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateGuestAcceleratorOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig {
}
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig): any;
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig): any;
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfig | undefined);
    get natIp(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange {
}
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange): any;
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange): any;
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRange | undefined);
    get ipCidrRange(): string;
    get subnetworkRangeName(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig {
}
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig): any;
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig): any;
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfig | undefined);
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    get name(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateNetworkInterface {
}
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterface): any;
export declare function dataGoogleComputeRegionInstanceTemplateNetworkInterfaceToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkInterface): any;
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateNetworkInterface | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateNetworkInterface | undefined);
    private _accessConfig;
    get accessConfig(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAccessConfigList;
    private _aliasIpRange;
    get aliasIpRange(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceAliasIpRangeList;
    get internalIpv6PrefixLength(): number;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceIpv6AccessConfigList;
    get ipv6AccessType(): string;
    get ipv6Address(): string;
    get name(): string;
    get network(): string;
    get networkIp(): string;
    get nicType(): string;
    get queueCount(): number;
    get stackType(): string;
    get subnetwork(): string;
    get subnetworkProject(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfig {
}
export declare function dataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfigToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfig): any;
export declare function dataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfigToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfig): any;
export declare class DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfig | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfig | undefined);
    get totalEgressBandwidthTier(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfigOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation {
}
export declare function dataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation): any;
export declare function dataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation): any;
export declare class DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservation | undefined);
    get key(): string;
    get values(): string[];
}
export declare class DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateReservationAffinity {
}
export declare function dataGoogleComputeRegionInstanceTemplateReservationAffinityToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateReservationAffinity): any;
export declare function dataGoogleComputeRegionInstanceTemplateReservationAffinityToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateReservationAffinity): any;
export declare class DataGoogleComputeRegionInstanceTemplateReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateReservationAffinity | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateReservationAffinity | undefined);
    private _specificReservation;
    get specificReservation(): DataGoogleComputeRegionInstanceTemplateReservationAffinitySpecificReservationList;
    get type(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateReservationAffinityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateReservationAffinityOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout {
}
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout): any;
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout): any;
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeout | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration {
}
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration): any;
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration): any;
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDuration | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinities {
}
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinities): any;
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinities): any;
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinities | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinities | undefined);
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateScheduling {
}
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateScheduling): any;
export declare function dataGoogleComputeRegionInstanceTemplateSchedulingToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateScheduling): any;
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateScheduling | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateScheduling | undefined);
    get automaticRestart(): cdktf.IResolvable;
    get instanceTerminationAction(): string;
    private _localSsdRecoveryTimeout;
    get localSsdRecoveryTimeout(): DataGoogleComputeRegionInstanceTemplateSchedulingLocalSsdRecoveryTimeoutList;
    get maintenanceInterval(): string;
    private _maxRunDuration;
    get maxRunDuration(): DataGoogleComputeRegionInstanceTemplateSchedulingMaxRunDurationList;
    get minNodeCpus(): number;
    private _nodeAffinities;
    get nodeAffinities(): DataGoogleComputeRegionInstanceTemplateSchedulingNodeAffinitiesList;
    get onHostMaintenance(): string;
    get preemptible(): cdktf.IResolvable;
    get provisioningModel(): string;
}
export declare class DataGoogleComputeRegionInstanceTemplateSchedulingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateSchedulingOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateServiceAccount {
}
export declare function dataGoogleComputeRegionInstanceTemplateServiceAccountToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateServiceAccount): any;
export declare function dataGoogleComputeRegionInstanceTemplateServiceAccountToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateServiceAccount): any;
export declare class DataGoogleComputeRegionInstanceTemplateServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateServiceAccount | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateServiceAccount | undefined);
    get email(): string;
    get scopes(): string[];
}
export declare class DataGoogleComputeRegionInstanceTemplateServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateServiceAccountOutputReference;
}
export interface DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfig {
}
export declare function dataGoogleComputeRegionInstanceTemplateShieldedInstanceConfigToTerraform(struct?: DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfig): any;
export declare function dataGoogleComputeRegionInstanceTemplateShieldedInstanceConfigToHclTerraform(struct?: DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfig): any;
export declare class DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfig | undefined;
    set internalValue(value: DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfig | undefined);
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
    get enableVtpm(): cdktf.IResolvable;
}
export declare class DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template google_compute_region_instance_template}
*/
export declare class DataGoogleComputeRegionInstanceTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_region_instance_template";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeRegionInstanceTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeRegionInstanceTemplate to import
    * @param importFromId The id of the existing DataGoogleComputeRegionInstanceTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeRegionInstanceTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_instance_template google_compute_region_instance_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRegionInstanceTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeRegionInstanceTemplateConfig);
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): DataGoogleComputeRegionInstanceTemplateAdvancedMachineFeaturesList;
    get canIpForward(): cdktf.IResolvable;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): DataGoogleComputeRegionInstanceTemplateConfidentialInstanceConfigList;
    get description(): string;
    private _disk;
    get disk(): DataGoogleComputeRegionInstanceTemplateDiskList;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get enableDisplay(): cdktf.IResolvable;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _guestAccelerator;
    get guestAccelerator(): DataGoogleComputeRegionInstanceTemplateGuestAcceleratorList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceDescription(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get machineType(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    get metadataFingerprint(): string;
    get metadataStartupScript(): string;
    get minCpuPlatform(): string;
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get namePrefix(): string;
    private _networkInterface;
    get networkInterface(): DataGoogleComputeRegionInstanceTemplateNetworkInterfaceList;
    private _networkPerformanceConfig;
    get networkPerformanceConfig(): DataGoogleComputeRegionInstanceTemplateNetworkPerformanceConfigList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _reservationAffinity;
    get reservationAffinity(): DataGoogleComputeRegionInstanceTemplateReservationAffinityList;
    private _resourceManagerTags;
    get resourceManagerTags(): cdktf.StringMap;
    get resourcePolicies(): string[];
    private _scheduling;
    get scheduling(): DataGoogleComputeRegionInstanceTemplateSchedulingList;
    get selfLink(): string;
    private _serviceAccount;
    get serviceAccount(): DataGoogleComputeRegionInstanceTemplateServiceAccountList;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataGoogleComputeRegionInstanceTemplateShieldedInstanceConfigList;
    get tags(): string[];
    get tagsFingerprint(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
