/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeRegionNetworkEndpointGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group#id DataGoogleComputeRegionNetworkEndpointGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource; provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group#name DataGoogleComputeRegionNetworkEndpointGroup#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group#project DataGoogleComputeRegionNetworkEndpointGroup#project}
    */
    readonly project?: string;
    /**
    * A reference to the region where the regional NEGs reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group#region DataGoogleComputeRegionNetworkEndpointGroup#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group#self_link DataGoogleComputeRegionNetworkEndpointGroup#self_link}
    */
    readonly selfLink?: string;
}
export interface DataGoogleComputeRegionNetworkEndpointGroupAppEngine {
}
export declare function dataGoogleComputeRegionNetworkEndpointGroupAppEngineToTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupAppEngine): any;
export declare function dataGoogleComputeRegionNetworkEndpointGroupAppEngineToHclTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupAppEngine): any;
export declare class DataGoogleComputeRegionNetworkEndpointGroupAppEngineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionNetworkEndpointGroupAppEngine | undefined;
    set internalValue(value: DataGoogleComputeRegionNetworkEndpointGroupAppEngine | undefined);
    get service(): string;
    get urlMask(): string;
    get version(): string;
}
export declare class DataGoogleComputeRegionNetworkEndpointGroupAppEngineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionNetworkEndpointGroupAppEngineOutputReference;
}
export interface DataGoogleComputeRegionNetworkEndpointGroupCloudFunction {
}
export declare function dataGoogleComputeRegionNetworkEndpointGroupCloudFunctionToTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupCloudFunction): any;
export declare function dataGoogleComputeRegionNetworkEndpointGroupCloudFunctionToHclTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupCloudFunction): any;
export declare class DataGoogleComputeRegionNetworkEndpointGroupCloudFunctionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionNetworkEndpointGroupCloudFunction | undefined;
    set internalValue(value: DataGoogleComputeRegionNetworkEndpointGroupCloudFunction | undefined);
    get function(): string;
    get urlMask(): string;
}
export declare class DataGoogleComputeRegionNetworkEndpointGroupCloudFunctionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionNetworkEndpointGroupCloudFunctionOutputReference;
}
export interface DataGoogleComputeRegionNetworkEndpointGroupCloudRun {
}
export declare function dataGoogleComputeRegionNetworkEndpointGroupCloudRunToTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupCloudRun): any;
export declare function dataGoogleComputeRegionNetworkEndpointGroupCloudRunToHclTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupCloudRun): any;
export declare class DataGoogleComputeRegionNetworkEndpointGroupCloudRunOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionNetworkEndpointGroupCloudRun | undefined;
    set internalValue(value: DataGoogleComputeRegionNetworkEndpointGroupCloudRun | undefined);
    get service(): string;
    get tag(): string;
    get urlMask(): string;
}
export declare class DataGoogleComputeRegionNetworkEndpointGroupCloudRunList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionNetworkEndpointGroupCloudRunOutputReference;
}
export interface DataGoogleComputeRegionNetworkEndpointGroupServerlessDeployment {
}
export declare function dataGoogleComputeRegionNetworkEndpointGroupServerlessDeploymentToTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupServerlessDeployment): any;
export declare function dataGoogleComputeRegionNetworkEndpointGroupServerlessDeploymentToHclTerraform(struct?: DataGoogleComputeRegionNetworkEndpointGroupServerlessDeployment): any;
export declare class DataGoogleComputeRegionNetworkEndpointGroupServerlessDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeRegionNetworkEndpointGroupServerlessDeployment | undefined;
    set internalValue(value: DataGoogleComputeRegionNetworkEndpointGroupServerlessDeployment | undefined);
    get platform(): string;
    get resource(): string;
    get urlMask(): string;
    get version(): string;
}
export declare class DataGoogleComputeRegionNetworkEndpointGroupServerlessDeploymentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeRegionNetworkEndpointGroupServerlessDeploymentOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group google_compute_region_network_endpoint_group}
*/
export declare class DataGoogleComputeRegionNetworkEndpointGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_region_network_endpoint_group";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeRegionNetworkEndpointGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeRegionNetworkEndpointGroup to import
    * @param importFromId The id of the existing DataGoogleComputeRegionNetworkEndpointGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeRegionNetworkEndpointGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_region_network_endpoint_group google_compute_region_network_endpoint_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeRegionNetworkEndpointGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeRegionNetworkEndpointGroupConfig);
    private _appEngine;
    get appEngine(): DataGoogleComputeRegionNetworkEndpointGroupAppEngineList;
    private _cloudFunction;
    get cloudFunction(): DataGoogleComputeRegionNetworkEndpointGroupCloudFunctionList;
    private _cloudRun;
    get cloudRun(): DataGoogleComputeRegionNetworkEndpointGroupCloudRunList;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get network(): string;
    get networkEndpointType(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pscTargetService(): string;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _selfLink?;
    get selfLink(): string;
    set selfLink(value: string);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    private _serverlessDeployment;
    get serverlessDeployment(): DataGoogleComputeRegionNetworkEndpointGroupServerlessDeploymentList;
    get subnetwork(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
