/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation#id DataGoogleComputeReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation#name DataGoogleComputeReservation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation#project DataGoogleComputeReservation#project}
    */
    readonly project?: string;
    /**
    * The zone where the reservation is made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation#zone DataGoogleComputeReservation#zone}
    */
    readonly zone: string;
}
export interface DataGoogleComputeReservationShareSettingsProjectMap {
}
export declare function dataGoogleComputeReservationShareSettingsProjectMapToTerraform(struct?: DataGoogleComputeReservationShareSettingsProjectMap): any;
export declare function dataGoogleComputeReservationShareSettingsProjectMapToHclTerraform(struct?: DataGoogleComputeReservationShareSettingsProjectMap): any;
export declare class DataGoogleComputeReservationShareSettingsProjectMapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeReservationShareSettingsProjectMap | undefined;
    set internalValue(value: DataGoogleComputeReservationShareSettingsProjectMap | undefined);
    get id(): string;
    get projectId(): string;
}
export declare class DataGoogleComputeReservationShareSettingsProjectMapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeReservationShareSettingsProjectMapOutputReference;
}
export interface DataGoogleComputeReservationShareSettings {
}
export declare function dataGoogleComputeReservationShareSettingsToTerraform(struct?: DataGoogleComputeReservationShareSettings): any;
export declare function dataGoogleComputeReservationShareSettingsToHclTerraform(struct?: DataGoogleComputeReservationShareSettings): any;
export declare class DataGoogleComputeReservationShareSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeReservationShareSettings | undefined;
    set internalValue(value: DataGoogleComputeReservationShareSettings | undefined);
    private _projectMap;
    get projectMap(): DataGoogleComputeReservationShareSettingsProjectMapList;
    get shareType(): string;
}
export declare class DataGoogleComputeReservationShareSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeReservationShareSettingsOutputReference;
}
export interface DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators {
}
export declare function dataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsToTerraform(struct?: DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators): any;
export declare function dataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsToHclTerraform(struct?: DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators): any;
export declare class DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | undefined;
    set internalValue(value: DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAccelerators | undefined);
    get acceleratorCount(): number;
    get acceleratorType(): string;
}
export declare class DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsOutputReference;
}
export interface DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds {
}
export declare function dataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsToTerraform(struct?: DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds): any;
export declare function dataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsToHclTerraform(struct?: DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds): any;
export declare class DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds | undefined;
    set internalValue(value: DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsds | undefined);
    get diskSizeGb(): number;
    get interface(): string;
}
export declare class DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsOutputReference;
}
export interface DataGoogleComputeReservationSpecificReservationInstanceProperties {
}
export declare function dataGoogleComputeReservationSpecificReservationInstancePropertiesToTerraform(struct?: DataGoogleComputeReservationSpecificReservationInstanceProperties): any;
export declare function dataGoogleComputeReservationSpecificReservationInstancePropertiesToHclTerraform(struct?: DataGoogleComputeReservationSpecificReservationInstanceProperties): any;
export declare class DataGoogleComputeReservationSpecificReservationInstancePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeReservationSpecificReservationInstanceProperties | undefined;
    set internalValue(value: DataGoogleComputeReservationSpecificReservationInstanceProperties | undefined);
    private _guestAccelerators;
    get guestAccelerators(): DataGoogleComputeReservationSpecificReservationInstancePropertiesGuestAcceleratorsList;
    private _localSsds;
    get localSsds(): DataGoogleComputeReservationSpecificReservationInstancePropertiesLocalSsdsList;
    get machineType(): string;
    get minCpuPlatform(): string;
}
export declare class DataGoogleComputeReservationSpecificReservationInstancePropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeReservationSpecificReservationInstancePropertiesOutputReference;
}
export interface DataGoogleComputeReservationSpecificReservation {
}
export declare function dataGoogleComputeReservationSpecificReservationToTerraform(struct?: DataGoogleComputeReservationSpecificReservation): any;
export declare function dataGoogleComputeReservationSpecificReservationToHclTerraform(struct?: DataGoogleComputeReservationSpecificReservation): any;
export declare class DataGoogleComputeReservationSpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeReservationSpecificReservation | undefined;
    set internalValue(value: DataGoogleComputeReservationSpecificReservation | undefined);
    get count(): number;
    get inUseCount(): number;
    private _instanceProperties;
    get instanceProperties(): DataGoogleComputeReservationSpecificReservationInstancePropertiesList;
}
export declare class DataGoogleComputeReservationSpecificReservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeReservationSpecificReservationOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation google_compute_reservation}
*/
export declare class DataGoogleComputeReservation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_reservation";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeReservation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeReservation to import
    * @param importFromId The id of the existing DataGoogleComputeReservation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeReservation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_reservation google_compute_reservation} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeReservationConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeReservationConfig);
    get commitment(): string;
    get creationTimestamp(): string;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _shareSettings;
    get shareSettings(): DataGoogleComputeReservationShareSettingsList;
    private _specificReservation;
    get specificReservation(): DataGoogleComputeReservationSpecificReservationList;
    get specificReservationRequired(): cdktf.IResolvable;
    get status(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
