/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeResourcePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy#id DataGoogleComputeResourcePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the resource, provided by the client when initially creating
    * the resource. The resource name must be 1-63 characters long, and comply
    * with RFC1035. Specifically, the name must be 1-63 characters long and
    * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])'? which means the
    * first character must be a lowercase letter, and all following characters
    * must be a dash, lowercase letter, or digit, except the last character,
    * which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy#name DataGoogleComputeResourcePolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy#project DataGoogleComputeResourcePolicy#project}
    */
    readonly project?: string;
    /**
    * Region where resource policy resides.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy#region DataGoogleComputeResourcePolicy#region}
    */
    readonly region?: string;
}
export interface DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicy {
}
export declare function dataGoogleComputeResourcePolicyDiskConsistencyGroupPolicyToTerraform(struct?: DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicy): any;
export declare function dataGoogleComputeResourcePolicyDiskConsistencyGroupPolicyToHclTerraform(struct?: DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicy): any;
export declare class DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicy | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicy | undefined);
    get enabled(): cdktf.IResolvable;
}
export declare class DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicyOutputReference;
}
export interface DataGoogleComputeResourcePolicyGroupPlacementPolicy {
}
export declare function dataGoogleComputeResourcePolicyGroupPlacementPolicyToTerraform(struct?: DataGoogleComputeResourcePolicyGroupPlacementPolicy): any;
export declare function dataGoogleComputeResourcePolicyGroupPlacementPolicyToHclTerraform(struct?: DataGoogleComputeResourcePolicyGroupPlacementPolicy): any;
export declare class DataGoogleComputeResourcePolicyGroupPlacementPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicyGroupPlacementPolicy | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicyGroupPlacementPolicy | undefined);
    get availabilityDomainCount(): number;
    get collocation(): string;
    get maxDistance(): number;
    get vmCount(): number;
}
export declare class DataGoogleComputeResourcePolicyGroupPlacementPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicyGroupPlacementPolicyOutputReference;
}
export interface DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule {
}
export declare function dataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleToTerraform(struct?: DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): any;
export declare function dataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleToHclTerraform(struct?: DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule): any;
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartSchedule | undefined);
    get schedule(): string;
}
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleOutputReference;
}
export interface DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule {
}
export declare function dataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleToTerraform(struct?: DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): any;
export declare function dataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleToHclTerraform(struct?: DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule): any;
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopSchedule | undefined);
    get schedule(): string;
}
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleOutputReference;
}
export interface DataGoogleComputeResourcePolicyInstanceSchedulePolicy {
}
export declare function dataGoogleComputeResourcePolicyInstanceSchedulePolicyToTerraform(struct?: DataGoogleComputeResourcePolicyInstanceSchedulePolicy): any;
export declare function dataGoogleComputeResourcePolicyInstanceSchedulePolicyToHclTerraform(struct?: DataGoogleComputeResourcePolicyInstanceSchedulePolicy): any;
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicyInstanceSchedulePolicy | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicyInstanceSchedulePolicy | undefined);
    get expirationTime(): string;
    get startTime(): string;
    get timeZone(): string;
    private _vmStartSchedule;
    get vmStartSchedule(): DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStartScheduleList;
    private _vmStopSchedule;
    get vmStopSchedule(): DataGoogleComputeResourcePolicyInstanceSchedulePolicyVmStopScheduleList;
}
export declare class DataGoogleComputeResourcePolicyInstanceSchedulePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicyInstanceSchedulePolicyOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicy | undefined);
    get maxRetentionDays(): number;
    get onSourceDiskDelete(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailySchedule | undefined);
    get daysInCycle(): number;
    get startTime(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlySchedule | undefined);
    get hoursInCycle(): number;
    get startTime(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeks | undefined);
    get day(): string;
    get startTime(): string;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklySchedule | undefined);
    private _dayOfWeeks;
    get dayOfWeeks(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleDayOfWeeksList;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicySchedule | undefined);
    private _dailySchedule;
    get dailySchedule(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleDailyScheduleList;
    private _hourlySchedule;
    get hourlySchedule(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleHourlyScheduleList;
    private _weeklySchedule;
    get weeklySchedule(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleWeeklyScheduleList;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotProperties | undefined);
    get chainName(): string;
    get guestFlush(): cdktf.IResolvable;
    private _labels;
    get labels(): cdktf.StringMap;
    get storageLocations(): string[];
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesOutputReference;
}
export interface DataGoogleComputeResourcePolicySnapshotSchedulePolicy {
}
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyToTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicy): any;
export declare function dataGoogleComputeResourcePolicySnapshotSchedulePolicyToHclTerraform(struct?: DataGoogleComputeResourcePolicySnapshotSchedulePolicy): any;
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeResourcePolicySnapshotSchedulePolicy | undefined;
    set internalValue(value: DataGoogleComputeResourcePolicySnapshotSchedulePolicy | undefined);
    private _retentionPolicy;
    get retentionPolicy(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyRetentionPolicyList;
    private _schedule;
    get schedule(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyScheduleList;
    private _snapshotProperties;
    get snapshotProperties(): DataGoogleComputeResourcePolicySnapshotSchedulePolicySnapshotPropertiesList;
}
export declare class DataGoogleComputeResourcePolicySnapshotSchedulePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeResourcePolicySnapshotSchedulePolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy google_compute_resource_policy}
*/
export declare class DataGoogleComputeResourcePolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_resource_policy";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeResourcePolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeResourcePolicy to import
    * @param importFromId The id of the existing DataGoogleComputeResourcePolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeResourcePolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_resource_policy google_compute_resource_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeResourcePolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeResourcePolicyConfig);
    get description(): string;
    private _diskConsistencyGroupPolicy;
    get diskConsistencyGroupPolicy(): DataGoogleComputeResourcePolicyDiskConsistencyGroupPolicyList;
    private _groupPlacementPolicy;
    get groupPlacementPolicy(): DataGoogleComputeResourcePolicyGroupPlacementPolicyList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceSchedulePolicy;
    get instanceSchedulePolicy(): DataGoogleComputeResourcePolicyInstanceSchedulePolicyList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _snapshotSchedulePolicy;
    get snapshotSchedulePolicy(): DataGoogleComputeResourcePolicySnapshotSchedulePolicyList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
