/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot#filter DataGoogleComputeSnapshot#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot#id DataGoogleComputeSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot#most_recent DataGoogleComputeSnapshot#most_recent}
    */
    readonly mostRecent?: boolean | cdktf.IResolvable;
    /**
    * Name of the resource; provided by the client when the resource is
    * created. The name must be 1-63 characters long, and comply with
    * RFC1035. Specifically, the name must be 1-63 characters long and match
    * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
    * first character must be a lowercase letter, and all following
    * characters must be a dash, lowercase letter, or digit, except the last
    * character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot#name DataGoogleComputeSnapshot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot#project DataGoogleComputeSnapshot#project}
    */
    readonly project?: string;
}
export interface DataGoogleComputeSnapshotSnapshotEncryptionKey {
}
export declare function dataGoogleComputeSnapshotSnapshotEncryptionKeyToTerraform(struct?: DataGoogleComputeSnapshotSnapshotEncryptionKey): any;
export declare function dataGoogleComputeSnapshotSnapshotEncryptionKeyToHclTerraform(struct?: DataGoogleComputeSnapshotSnapshotEncryptionKey): any;
export declare class DataGoogleComputeSnapshotSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeSnapshotSnapshotEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeSnapshotSnapshotEncryptionKey | undefined);
    get kmsKeySelfLink(): string;
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
    get sha256(): string;
}
export declare class DataGoogleComputeSnapshotSnapshotEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeSnapshotSnapshotEncryptionKeyOutputReference;
}
export interface DataGoogleComputeSnapshotSourceDiskEncryptionKey {
}
export declare function dataGoogleComputeSnapshotSourceDiskEncryptionKeyToTerraform(struct?: DataGoogleComputeSnapshotSourceDiskEncryptionKey): any;
export declare function dataGoogleComputeSnapshotSourceDiskEncryptionKeyToHclTerraform(struct?: DataGoogleComputeSnapshotSourceDiskEncryptionKey): any;
export declare class DataGoogleComputeSnapshotSourceDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeSnapshotSourceDiskEncryptionKey | undefined;
    set internalValue(value: DataGoogleComputeSnapshotSourceDiskEncryptionKey | undefined);
    get kmsKeyServiceAccount(): string;
    get rawKey(): string;
}
export declare class DataGoogleComputeSnapshotSourceDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeSnapshotSourceDiskEncryptionKeyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot google_compute_snapshot}
*/
export declare class DataGoogleComputeSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_snapshot";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeSnapshot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeSnapshot to import
    * @param importFromId The id of the existing DataGoogleComputeSnapshot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeSnapshot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_snapshot google_compute_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeSnapshotConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeSnapshotConfig);
    get chainName(): string;
    get creationTimestamp(): string;
    get description(): string;
    get diskSizeGb(): number;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get licenses(): string[];
    private _mostRecent?;
    get mostRecent(): boolean | cdktf.IResolvable;
    set mostRecent(value: boolean | cdktf.IResolvable);
    resetMostRecent(): void;
    get mostRecentInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _snapshotEncryptionKey;
    get snapshotEncryptionKey(): DataGoogleComputeSnapshotSnapshotEncryptionKeyList;
    get snapshotId(): number;
    get sourceDisk(): string;
    private _sourceDiskEncryptionKey;
    get sourceDiskEncryptionKey(): DataGoogleComputeSnapshotSourceDiskEncryptionKeyList;
    get storageBytes(): number;
    get storageLocations(): string[];
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get zone(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
