/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeSubnetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork#id DataGoogleComputeSubnetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork#name DataGoogleComputeSubnetwork#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork#project DataGoogleComputeSubnetwork#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork#region DataGoogleComputeSubnetwork#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork#self_link DataGoogleComputeSubnetwork#self_link}
    */
    readonly selfLink?: string;
}
export interface DataGoogleComputeSubnetworkSecondaryIpRange {
}
export declare function dataGoogleComputeSubnetworkSecondaryIpRangeToTerraform(struct?: DataGoogleComputeSubnetworkSecondaryIpRange): any;
export declare function dataGoogleComputeSubnetworkSecondaryIpRangeToHclTerraform(struct?: DataGoogleComputeSubnetworkSecondaryIpRange): any;
export declare class DataGoogleComputeSubnetworkSecondaryIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeSubnetworkSecondaryIpRange | undefined;
    set internalValue(value: DataGoogleComputeSubnetworkSecondaryIpRange | undefined);
    get ipCidrRange(): string;
    get rangeName(): string;
}
export declare class DataGoogleComputeSubnetworkSecondaryIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeSubnetworkSecondaryIpRangeOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork google_compute_subnetwork}
*/
export declare class DataGoogleComputeSubnetwork extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_subnetwork";
    /**
    * Generates CDKTF code for importing a DataGoogleComputeSubnetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleComputeSubnetwork to import
    * @param importFromId The id of the existing DataGoogleComputeSubnetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleComputeSubnetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_compute_subnetwork google_compute_subnetwork} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeSubnetworkConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeSubnetworkConfig);
    get description(): string;
    get gatewayAddress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internalIpv6Prefix(): string;
    get ipCidrRange(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get network(): string;
    get privateIpGoogleAccess(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secondaryIpRange;
    get secondaryIpRange(): DataGoogleComputeSubnetworkSecondaryIpRangeList;
    private _selfLink?;
    get selfLink(): string;
    set selfLink(value: string);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
