"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataGoogleContainerCluster = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
// generated from terraform resource schema
const index_structs_1 = require("./index-structs");
__exportStar(require("./index-structs"), exports);
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_cluster google_container_cluster}
*/
class DataGoogleContainerCluster extends cdktf.TerraformDataSource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DataGoogleContainerCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataGoogleContainerCluster to import
    * @param importFromId The id of the existing DataGoogleContainerCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataGoogleContainerCluster to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "google_container_cluster", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/data-sources/google_container_cluster google_container_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerClusterConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_container_cluster',
            terraformGeneratorMetadata: {
                providerName: 'google-beta',
                providerVersion: '5.21.0',
                providerVersionConstraint: '~> 5.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // ==========
        // ATTRIBUTES
        // ==========
        // addons_config - computed: true, optional: false, required: false
        this._addonsConfig = new index_structs_1.DataGoogleContainerClusterAddonsConfigList(this, "addons_config", false);
        // authenticator_groups_config - computed: true, optional: false, required: false
        this._authenticatorGroupsConfig = new index_structs_1.DataGoogleContainerClusterAuthenticatorGroupsConfigList(this, "authenticator_groups_config", false);
        // binary_authorization - computed: true, optional: false, required: false
        this._binaryAuthorization = new index_structs_1.DataGoogleContainerClusterBinaryAuthorizationList(this, "binary_authorization", false);
        // cluster_autoscaling - computed: true, optional: false, required: false
        this._clusterAutoscaling = new index_structs_1.DataGoogleContainerClusterClusterAutoscalingList(this, "cluster_autoscaling", false);
        // cluster_telemetry - computed: true, optional: false, required: false
        this._clusterTelemetry = new index_structs_1.DataGoogleContainerClusterClusterTelemetryList(this, "cluster_telemetry", false);
        // confidential_nodes - computed: true, optional: false, required: false
        this._confidentialNodes = new index_structs_1.DataGoogleContainerClusterConfidentialNodesList(this, "confidential_nodes", false);
        // cost_management_config - computed: true, optional: false, required: false
        this._costManagementConfig = new index_structs_1.DataGoogleContainerClusterCostManagementConfigList(this, "cost_management_config", false);
        // database_encryption - computed: true, optional: false, required: false
        this._databaseEncryption = new index_structs_1.DataGoogleContainerClusterDatabaseEncryptionList(this, "database_encryption", false);
        // default_snat_status - computed: true, optional: false, required: false
        this._defaultSnatStatus = new index_structs_1.DataGoogleContainerClusterDefaultSnatStatusList(this, "default_snat_status", false);
        // dns_config - computed: true, optional: false, required: false
        this._dnsConfig = new index_structs_1.DataGoogleContainerClusterDnsConfigList(this, "dns_config", false);
        // enable_k8s_beta_apis - computed: true, optional: false, required: false
        this._enableK8SBetaApis = new index_structs_1.DataGoogleContainerClusterEnableK8SBetaApisList(this, "enable_k8s_beta_apis", false);
        // fleet - computed: true, optional: false, required: false
        this._fleet = new index_structs_1.DataGoogleContainerClusterFleetList(this, "fleet", false);
        // gateway_api_config - computed: true, optional: false, required: false
        this._gatewayApiConfig = new index_structs_1.DataGoogleContainerClusterGatewayApiConfigList(this, "gateway_api_config", false);
        // identity_service_config - computed: true, optional: false, required: false
        this._identityServiceConfig = new index_structs_1.DataGoogleContainerClusterIdentityServiceConfigList(this, "identity_service_config", false);
        // ip_allocation_policy - computed: true, optional: false, required: false
        this._ipAllocationPolicy = new index_structs_1.DataGoogleContainerClusterIpAllocationPolicyList(this, "ip_allocation_policy", false);
        // logging_config - computed: true, optional: false, required: false
        this._loggingConfig = new index_structs_1.DataGoogleContainerClusterLoggingConfigList(this, "logging_config", false);
        // maintenance_policy - computed: true, optional: false, required: false
        this._maintenancePolicy = new index_structs_1.DataGoogleContainerClusterMaintenancePolicyList(this, "maintenance_policy", false);
        // master_auth - computed: true, optional: false, required: false
        this._masterAuth = new index_structs_1.DataGoogleContainerClusterMasterAuthList(this, "master_auth", false);
        // master_authorized_networks_config - computed: true, optional: false, required: false
        this._masterAuthorizedNetworksConfig = new index_structs_1.DataGoogleContainerClusterMasterAuthorizedNetworksConfigList(this, "master_authorized_networks_config", false);
        // mesh_certificates - computed: true, optional: false, required: false
        this._meshCertificates = new index_structs_1.DataGoogleContainerClusterMeshCertificatesList(this, "mesh_certificates", false);
        // monitoring_config - computed: true, optional: false, required: false
        this._monitoringConfig = new index_structs_1.DataGoogleContainerClusterMonitoringConfigList(this, "monitoring_config", false);
        // network_policy - computed: true, optional: false, required: false
        this._networkPolicy = new index_structs_1.DataGoogleContainerClusterNetworkPolicyList(this, "network_policy", false);
        // node_config - computed: true, optional: false, required: false
        this._nodeConfig = new index_structs_1.DataGoogleContainerClusterNodeConfigList(this, "node_config", false);
        // node_pool - computed: true, optional: false, required: false
        this._nodePool = new index_structs_1.DataGoogleContainerClusterNodePoolList(this, "node_pool", false);
        // node_pool_auto_config - computed: true, optional: false, required: false
        this._nodePoolAutoConfig = new index_structs_1.DataGoogleContainerClusterNodePoolAutoConfigList(this, "node_pool_auto_config", false);
        // node_pool_defaults - computed: true, optional: false, required: false
        this._nodePoolDefaults = new index_structs_1.DataGoogleContainerClusterNodePoolDefaultsList(this, "node_pool_defaults", false);
        // notification_config - computed: true, optional: false, required: false
        this._notificationConfig = new index_structs_1.DataGoogleContainerClusterNotificationConfigList(this, "notification_config", false);
        // pod_security_policy_config - computed: true, optional: false, required: false
        this._podSecurityPolicyConfig = new index_structs_1.DataGoogleContainerClusterPodSecurityPolicyConfigList(this, "pod_security_policy_config", false);
        // private_cluster_config - computed: true, optional: false, required: false
        this._privateClusterConfig = new index_structs_1.DataGoogleContainerClusterPrivateClusterConfigList(this, "private_cluster_config", false);
        // protect_config - computed: true, optional: false, required: false
        this._protectConfig = new index_structs_1.DataGoogleContainerClusterProtectConfigList(this, "protect_config", false);
        // release_channel - computed: true, optional: false, required: false
        this._releaseChannel = new index_structs_1.DataGoogleContainerClusterReleaseChannelList(this, "release_channel", false);
        // resource_labels - computed: true, optional: false, required: false
        this._resourceLabels = new cdktf.StringMap(this, "resource_labels");
        // resource_usage_export_config - computed: true, optional: false, required: false
        this._resourceUsageExportConfig = new index_structs_1.DataGoogleContainerClusterResourceUsageExportConfigList(this, "resource_usage_export_config", false);
        // security_posture_config - computed: true, optional: false, required: false
        this._securityPostureConfig = new index_structs_1.DataGoogleContainerClusterSecurityPostureConfigList(this, "security_posture_config", false);
        // service_external_ips_config - computed: true, optional: false, required: false
        this._serviceExternalIpsConfig = new index_structs_1.DataGoogleContainerClusterServiceExternalIpsConfigList(this, "service_external_ips_config", false);
        // tpu_config - computed: true, optional: false, required: false
        this._tpuConfig = new index_structs_1.DataGoogleContainerClusterTpuConfigList(this, "tpu_config", false);
        // vertical_pod_autoscaling - computed: true, optional: false, required: false
        this._verticalPodAutoscaling = new index_structs_1.DataGoogleContainerClusterVerticalPodAutoscalingList(this, "vertical_pod_autoscaling", false);
        // workload_alts_config - computed: true, optional: false, required: false
        this._workloadAltsConfig = new index_structs_1.DataGoogleContainerClusterWorkloadAltsConfigList(this, "workload_alts_config", false);
        // workload_identity_config - computed: true, optional: false, required: false
        this._workloadIdentityConfig = new index_structs_1.DataGoogleContainerClusterWorkloadIdentityConfigList(this, "workload_identity_config", false);
        this._id = config.id;
        this._location = config.location;
        this._name = config.name;
        this._project = config.project;
    }
    get addonsConfig() {
        return this._addonsConfig;
    }
    // allow_net_admin - computed: true, optional: false, required: false
    get allowNetAdmin() {
        return this.getBooleanAttribute('allow_net_admin');
    }
    get authenticatorGroupsConfig() {
        return this._authenticatorGroupsConfig;
    }
    get binaryAuthorization() {
        return this._binaryAuthorization;
    }
    get clusterAutoscaling() {
        return this._clusterAutoscaling;
    }
    // cluster_ipv4_cidr - computed: true, optional: false, required: false
    get clusterIpv4Cidr() {
        return this.getStringAttribute('cluster_ipv4_cidr');
    }
    get clusterTelemetry() {
        return this._clusterTelemetry;
    }
    get confidentialNodes() {
        return this._confidentialNodes;
    }
    get costManagementConfig() {
        return this._costManagementConfig;
    }
    get databaseEncryption() {
        return this._databaseEncryption;
    }
    // datapath_provider - computed: true, optional: false, required: false
    get datapathProvider() {
        return this.getStringAttribute('datapath_provider');
    }
    // default_max_pods_per_node - computed: true, optional: false, required: false
    get defaultMaxPodsPerNode() {
        return this.getNumberAttribute('default_max_pods_per_node');
    }
    get defaultSnatStatus() {
        return this._defaultSnatStatus;
    }
    // deletion_protection - computed: true, optional: false, required: false
    get deletionProtection() {
        return this.getBooleanAttribute('deletion_protection');
    }
    // description - computed: true, optional: false, required: false
    get description() {
        return this.getStringAttribute('description');
    }
    get dnsConfig() {
        return this._dnsConfig;
    }
    // enable_autopilot - computed: true, optional: false, required: false
    get enableAutopilot() {
        return this.getBooleanAttribute('enable_autopilot');
    }
    // enable_fqdn_network_policy - computed: true, optional: false, required: false
    get enableFqdnNetworkPolicy() {
        return this.getBooleanAttribute('enable_fqdn_network_policy');
    }
    // enable_intranode_visibility - computed: true, optional: false, required: false
    get enableIntranodeVisibility() {
        return this.getBooleanAttribute('enable_intranode_visibility');
    }
    get enableK8SBetaApis() {
        return this._enableK8SBetaApis;
    }
    // enable_kubernetes_alpha - computed: true, optional: false, required: false
    get enableKubernetesAlpha() {
        return this.getBooleanAttribute('enable_kubernetes_alpha');
    }
    // enable_l4_ilb_subsetting - computed: true, optional: false, required: false
    get enableL4IlbSubsetting() {
        return this.getBooleanAttribute('enable_l4_ilb_subsetting');
    }
    // enable_legacy_abac - computed: true, optional: false, required: false
    get enableLegacyAbac() {
        return this.getBooleanAttribute('enable_legacy_abac');
    }
    // enable_multi_networking - computed: true, optional: false, required: false
    get enableMultiNetworking() {
        return this.getBooleanAttribute('enable_multi_networking');
    }
    // enable_shielded_nodes - computed: true, optional: false, required: false
    get enableShieldedNodes() {
        return this.getBooleanAttribute('enable_shielded_nodes');
    }
    // enable_tpu - computed: true, optional: false, required: false
    get enableTpu() {
        return this.getBooleanAttribute('enable_tpu');
    }
    // endpoint - computed: true, optional: false, required: false
    get endpoint() {
        return this.getStringAttribute('endpoint');
    }
    get fleet() {
        return this._fleet;
    }
    get gatewayApiConfig() {
        return this._gatewayApiConfig;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get identityServiceConfig() {
        return this._identityServiceConfig;
    }
    // initial_node_count - computed: true, optional: false, required: false
    get initialNodeCount() {
        return this.getNumberAttribute('initial_node_count');
    }
    get ipAllocationPolicy() {
        return this._ipAllocationPolicy;
    }
    // label_fingerprint - computed: true, optional: false, required: false
    get labelFingerprint() {
        return this.getStringAttribute('label_fingerprint');
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    resetLocation() {
        this._location = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    get loggingConfig() {
        return this._loggingConfig;
    }
    // logging_service - computed: true, optional: false, required: false
    get loggingService() {
        return this.getStringAttribute('logging_service');
    }
    get maintenancePolicy() {
        return this._maintenancePolicy;
    }
    get masterAuth() {
        return this._masterAuth;
    }
    get masterAuthorizedNetworksConfig() {
        return this._masterAuthorizedNetworksConfig;
    }
    // master_version - computed: true, optional: false, required: false
    get masterVersion() {
        return this.getStringAttribute('master_version');
    }
    get meshCertificates() {
        return this._meshCertificates;
    }
    // min_master_version - computed: true, optional: false, required: false
    get minMasterVersion() {
        return this.getStringAttribute('min_master_version');
    }
    get monitoringConfig() {
        return this._monitoringConfig;
    }
    // monitoring_service - computed: true, optional: false, required: false
    get monitoringService() {
        return this.getStringAttribute('monitoring_service');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // network - computed: true, optional: false, required: false
    get network() {
        return this.getStringAttribute('network');
    }
    get networkPolicy() {
        return this._networkPolicy;
    }
    // networking_mode - computed: true, optional: false, required: false
    get networkingMode() {
        return this.getStringAttribute('networking_mode');
    }
    get nodeConfig() {
        return this._nodeConfig;
    }
    // node_locations - computed: true, optional: false, required: false
    get nodeLocations() {
        return cdktf.Fn.tolist(this.getListAttribute('node_locations'));
    }
    get nodePool() {
        return this._nodePool;
    }
    get nodePoolAutoConfig() {
        return this._nodePoolAutoConfig;
    }
    get nodePoolDefaults() {
        return this._nodePoolDefaults;
    }
    // node_version - computed: true, optional: false, required: false
    get nodeVersion() {
        return this.getStringAttribute('node_version');
    }
    get notificationConfig() {
        return this._notificationConfig;
    }
    // operation - computed: true, optional: false, required: false
    get operation() {
        return this.getStringAttribute('operation');
    }
    get podSecurityPolicyConfig() {
        return this._podSecurityPolicyConfig;
    }
    get privateClusterConfig() {
        return this._privateClusterConfig;
    }
    // private_ipv6_google_access - computed: true, optional: false, required: false
    get privateIpv6GoogleAccess() {
        return this.getStringAttribute('private_ipv6_google_access');
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get protectConfig() {
        return this._protectConfig;
    }
    get releaseChannel() {
        return this._releaseChannel;
    }
    // remove_default_node_pool - computed: true, optional: false, required: false
    get removeDefaultNodePool() {
        return this.getBooleanAttribute('remove_default_node_pool');
    }
    get resourceLabels() {
        return this._resourceLabels;
    }
    get resourceUsageExportConfig() {
        return this._resourceUsageExportConfig;
    }
    get securityPostureConfig() {
        return this._securityPostureConfig;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get serviceExternalIpsConfig() {
        return this._serviceExternalIpsConfig;
    }
    // services_ipv4_cidr - computed: true, optional: false, required: false
    get servicesIpv4Cidr() {
        return this.getStringAttribute('services_ipv4_cidr');
    }
    // subnetwork - computed: true, optional: false, required: false
    get subnetwork() {
        return this.getStringAttribute('subnetwork');
    }
    get tpuConfig() {
        return this._tpuConfig;
    }
    // tpu_ipv4_cidr_block - computed: true, optional: false, required: false
    get tpuIpv4CidrBlock() {
        return this.getStringAttribute('tpu_ipv4_cidr_block');
    }
    get verticalPodAutoscaling() {
        return this._verticalPodAutoscaling;
    }
    get workloadAltsConfig() {
        return this._workloadAltsConfig;
    }
    get workloadIdentityConfig() {
        return this._workloadIdentityConfig;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            location: cdktf.stringToTerraform(this._location),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            location: {
                value: cdktf.stringToHclTerraform(this._location),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            project: {
                value: cdktf.stringToHclTerraform(this._project),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DataGoogleContainerCluster = DataGoogleContainerCluster;
_a = JSII_RTTI_SYMBOL_1;
DataGoogleContainerCluster[_a] = { fqn: "@cdktf/provider-google-beta.dataGoogleContainerCluster.DataGoogleContainerCluster", version: "13.10.0" };
// =================
// STATIC PROPERTIES
// =================
DataGoogleContainerCluster.tfResourceType = "google_container_cluster";
//# sourceMappingURL=data:application/json;base64,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